<?php

add_action( 'tgmpa_register', 'choicy_register_required_plugins' );

function choicy_register_required_plugins() {

    $plugins = [
        [
            'name'               => esc_html__( 'Choicy Core', 'choicy' ),
            'slug'               => 'choicy-core',
            'source'             => esc_url( 'https://themexriver.com/wp/choicy/choicy-plug/choicy-core.zip' ),
            'external_url'       => esc_url( 'https://themexriver.com/wp/choicy/choicy-plug/choicy-core.zip' ),
            'required'           => true,
            'force_activation'   => false,
            'force_deactivation' => false,
        ],
        [
            'name'     => esc_html__( 'Elementor Page Builder', 'choicy' ),
            'slug'     => 'elementor',
            'required' => true,
        ],
        [
            'name'     => esc_html__( 'WP Classic Editor', 'choicy' ),
            'slug'     => 'classic-editor',
            'required' => false,
        ],
        [
            'name'     => esc_html__( 'Contact Form 7', 'choicy' ),
            'slug'     => 'contact-form-7',
            'required' => true,
        ],
        [
            'name'     => esc_html__( 'WooCommerce', 'choicy' ),
            'slug'     => 'woocommerce',
            'required' => true,
        ],
        [
            'name'     => esc_html__( 'One Click Demo Import', 'choicy' ),
            'slug'     => 'one-click-demo-import',
            'required' => false,
        ],
        [
            'name'     => esc_html__( 'SVG Support', 'choicy' ),
            'slug'     => 'svg-support',
            'required' => false,
        ],

    ];

    $config = [
        'id'           => 'choicy',
        'parent_slug'  => 'choicy',
        'menu'         => 'tgmpa-install-plugins',
        'dismissable'  => true,
        'dismiss_msg'  => '',
        'is_automatic' => false,
        'message'      => '',
        'default_path' => '',
    ];

    tgmpa( $plugins, $config );
}
