<?php

/**
 * Default Header Style
 */
function choicy_default_header() {
    if ( has_nav_menu( 'main-menu' ) ) {
        $no_menu_class = '';
    } else {
        $no_menu_class = 'no-menu ';
    }

    ?>
	<header class="chy-header-1-area has-inner-page transparent-header tx-header tx-DefaultHeader <?php echo esc_attr($no_menu_class); ?>">
		<div class="container chy-container-1">
			<div class="chy-header-1-wrap">
				<div class="left d-lg-none">
					<!-- menu-btn -->
					<div class="chy-menu-btn-1 open_mobile_menu d-lg-none" id="menuToggle">
						<i class="fa-light fa-bars icon-1"></i>
						<i class="fa-regular fa-angle-left icon-2"></i>
					</div>
				</div>
				<!-- logo -->
				<?php function_exists( 'choicy_header_logo' ) ? choicy_header_logo() : '';?>

				<!-- menu -->
				<div class="chy-main-menu-1 d-none d-lg-block">
					<nav class="main-navigation clearfix ul-li">
						<?php function_exists( 'choicy_header_menu' ) ? choicy_header_menu( 'main-menu' ) : null;?>
					</nav>
				</div>

			</div>
		</div>
	</header>

	<div class="fullpage-menu">
		<div class="fullpage-menu-inner">
			<div class="menu-bg">
				<span class="span1"></span>
				<span class="span2"></span>
				<span class="span3"></span>
			</div>

			<div class="fullpage-menu-logo-wrap">
				<?php function_exists( 'choicy_side_info_logo' ) ? choicy_side_info_logo() : '';?>
				<i id="menuToggle2" class="fas fullpage-menu-close fa-times"></i>
			</div>
			<!-- mobile-menu-list -->
			<nav class="mobile-main-navigation  clearfix ul-li">
				<?php function_exists( 'choicy_header_menu' ) ? choicy_header_menu( 'main-menu' ) : null;?>
			</nav>
		</div>
	</div>

    <?php
}
