<?php

/**
 * choicy_scripts description
 * @return [type] [description]
 */
function choicy_scripts() {

    wp_enqueue_style( 'choicy-fonts', choicy_fonts_url(), [], null );
    wp_enqueue_style( 'bootstrap-min', CHOICY_THEME_CSS_DIR . 'bootstrap.min.css', [] );
    wp_enqueue_style( 'fontawesome-min', CHOICY_THEME_CSS_DIR . 'fontawesome.min.css', [] );
    wp_enqueue_style( 'flaticon_choicy', CHOICY_THEME_CSS_DIR . 'flaticon_choicy.css', [] );
    wp_enqueue_style( 'animate', CHOICY_THEME_CSS_DIR . 'animate.css', [], VERSION );
    wp_enqueue_style( 'odometer-min', CHOICY_THEME_CSS_DIR . 'odometer.min.css', [], VERSION );
    wp_enqueue_style( 'magnific-popup', CHOICY_THEME_CSS_DIR . 'magnific-popup.css', [], VERSION );
    wp_enqueue_style( 'swiper-min', CHOICY_THEME_CSS_DIR . 'swiper.min.css', [], VERSION );
    wp_enqueue_style( 'nice-select-min', CHOICY_THEME_CSS_DIR . 'nice-select.min.css', [], VERSION );
    wp_enqueue_style( 'choicy-core', CHOICY_THEME_CSS_DIR . 'choicy-core.css', [], VERSION );
    wp_enqueue_style( 'choicy-companion', CHOICY_THEME_CSS_DIR . 'choicy-companion.css', [] );
    wp_enqueue_style( 'choicy-custom', CHOICY_THEME_CSS_DIR . 'choicy-custom.css', [] );
    wp_enqueue_style( 'choicy-woocommerce', CHOICY_THEME_CSS_DIR . 'choicy-woocommerce.css', [] );
    wp_enqueue_style( 'choicy-style', get_stylesheet_uri() );

    if ( class_exists('WooCommerce') ) {
		wp_enqueue_style( 'woocommerce-style', get_template_directory_uri() . '/woocommerce/woocommerce.css' );
	}

    $my_current_lang = apply_filters( 'wpml_current_language', NULL );

    $enable_rtl = cs_get_option( 'enable_rtl', false );
    if ( $my_current_lang != 'en' && $enable_rtl || is_rtl() ) {
        wp_enqueue_style( 'choicy-rtl', CHOICY_THEME_CSS_DIR . 'choicy-rtl.css', [] );
    }

    // all js files
    wp_enqueue_script( 'bootstrap-min', CHOICY_THEME_JS_DIR . 'bootstrap-min.js', ['jquery'], false, true );
    wp_enqueue_script( 'swiper-min', CHOICY_THEME_JS_DIR . 'swiper.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'wow-min', CHOICY_THEME_JS_DIR . 'wow-min.js', ['jquery'], false, true );
    wp_enqueue_script( 'SplitText-min', CHOICY_THEME_JS_DIR . 'SplitText.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'gsap-min', CHOICY_THEME_JS_DIR . 'gsap.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'tilt-jquery-min', CHOICY_THEME_JS_DIR . 'tilt.jquery.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'waypoints-min', CHOICY_THEME_JS_DIR . 'waypoints.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'split-type-min', CHOICY_THEME_JS_DIR . 'split-type.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'ScrollTrigger-min', CHOICY_THEME_JS_DIR . 'ScrollTrigger.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'marquee', CHOICY_THEME_JS_DIR . 'marquee.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'odometer-min', CHOICY_THEME_JS_DIR . 'odometer.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'counterup-min', CHOICY_THEME_JS_DIR . 'counterup.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'magnific-popup-min', CHOICY_THEME_JS_DIR . 'magnific-popup.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'knob-min', CHOICY_THEME_JS_DIR . 'knob.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'touchspin', CHOICY_THEME_JS_DIR . 'touchspin.js', ['jquery'], false, true );
    wp_enqueue_script( 'appear-min', CHOICY_THEME_JS_DIR . 'appear.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'jquery-nice-select-min', CHOICY_THEME_JS_DIR . 'jquery-nice-select.min.js', ['jquery'], false, true );
    wp_enqueue_script( 'choicy-custom', CHOICY_THEME_JS_DIR . 'choicy-custom.js', ['jquery'], false, true );

    if ( $my_current_lang != 'en' && $enable_rtl || is_rtl() ) {
        wp_enqueue_script( 'choicy-core-rtl', CHOICY_THEME_JS_DIR . 'choicy-core-rtl.js', ['jquery'], VERSION, true );
    } else {
        wp_enqueue_script( 'choicy-core', CHOICY_THEME_JS_DIR . 'choicy-core.js', ['jquery'], VERSION, true );
    }

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }

}
add_action( 'wp_enqueue_scripts', 'choicy_scripts' );