<?php

// File Security Check
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

function choicy_primary_color() {

    wp_enqueue_style( 'choicy-primary-color', CHOICY_THEME_CSS_DIR . 'choicy-custom.css', [] );

    $theme_primary_color = cs_get_option( 'theme_primary_color', '#A249ED' );
    $theme_color_2 = cs_get_option( 'theme_color_2', '#ee4619'  );
    $theme_color_3 = cs_get_option( 'theme_color_3', '#27f67a' );
    $theme_color_4 = cs_get_option( 'theme_color_4', '#f28541' );
    $theme_color_5 = cs_get_option( 'theme_color_5', '#9255CE' );
    $theme_color_6 = cs_get_option( 'theme_color_6', '#7237E9' );
    $theme_gd_color_1 = cs_get_option( 'theme_gd_color_1' );
    $theme_gd_color_2 = cs_get_option( 'theme_gd_color_2' );

    if (
        $theme_primary_color ||
        $theme_color_2 ||
        $theme_color_3 ||
        $theme_color_4 ||
        $theme_color_5 ||
        $theme_color_6
    ) {
        $custom_css = '';
        $custom_css .= '
            :root {
                --chy-pr-1: ' . esc_attr( $theme_primary_color ) . ';
                --chy-pr-2: ' . esc_attr( $theme_color_2 ) . ';
                --chy-pr-3: ' . esc_attr( $theme_color_3 ) . ';
                --chy-pr-4: ' . esc_attr( $theme_color_4 ) . ';
                --chy-pr-5: ' . esc_attr( $theme_color_5 ) . ';
                --chy-sd-1: ' . esc_attr( $theme_color_6 ) . ';
            }
        ';

        wp_add_inline_style( 'choicy-primary-color', $custom_css );
    }

    if(isset( $theme_gd_color_1['color_1'] ) || isset( $theme_gd_color_1['color_2'] ) || isset( $theme_gd_color_2['color_1'] ) || isset( $theme_gd_color_2['color_2'] ) ) {
        $custom_css = '';
        $custom_css .= '
            :root {
                --chy-gd-1: linear-gradient( 32deg, ' . esc_attr( $theme_gd_color_1['color_1'] ) . ' 20%, ' . esc_attr( $theme_gd_color_1['color_2'] ) . ' 100%);
                --chy-gd-2: linear-gradient(90deg, ' . esc_attr( $theme_gd_color_2['color_1'] ) . ' -2.17%, ' . esc_attr( $theme_gd_color_2['color_2'] ) . ' 100%);
            }
        ';

        wp_add_inline_style( 'choicy-primary-color', $custom_css );
    }
}
add_action( 'wp_enqueue_scripts', 'choicy_primary_color' );