<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-layouts
 *
 * @package choicy
 */

$preloader_enable = cs_get_option( 'preloader_enable', true );
$preloader_image_enable = cs_get_option( 'preloader_image_enable', true );

$enable_scroll_up = cs_get_option( 'enable_scroll_up', true );
if( $preloader_image_enable == true )  {
    $has_img = 'has-img';
    $preloader_image = cs_get_option( 'preloader_image', get_template_directory_uri() . '/assets/img/logo/logo-white.webp');

    if(isset($preloader_image['url'])) {
        $image_url = $preloader_image['url'];
    } else {
        $image_url = get_template_directory_uri() . '/assets/img/logo/logo-white.webp';
    }
} else {
    $image_url = '';
    $has_img = '';
}


?>

<!doctype html>
<html <?php if(function_exists('language_attributes')) {language_attributes();} ?> <?php if(function_exists('choicy_enable_rtl')) { print choicy_enable_rtl();} ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' );?>">
    <?php if ( is_singular() && pings_open( get_queried_object() ) ): ?>
    <?php endif;?>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head();?>
</head>

<body <?php body_class();?>>
<?php wp_body_open();?>

<div class="page-wrapper">

    <div class="offcanvas-overlay"></div>

    <!-- preloader start -->
    <?php if( $preloader_enable == true ) : ?>
    <div id="tx_preloader" class="<?php echo esc_attr($has_img); ?>">
        <div class="loader_line">
            <?php if(!empty( $image_url )) : ?>
            <img src="<?php echo esc_attr($image_url); ?>" alt="<?php if(function_exists('choicy_img_alt_text')) { echo choicy_img_alt_text( $image_url ); } ?>">
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>
    <!-- preloader end -->

    <!-- back to top start -->
    <?php if( $enable_scroll_up == true ) : ?>
    <div class="scroll-top has-home-1">
        <div class="scroll-top-wrap">
            <i class="icon-1 fal fa-long-arrow-up"></i>
        </div>
    </div>
    <?php endif; ?>
    <!-- back to top end -->

    <!-- header start -->
    <?php do_action( 'choicy_header_style' ); ?>
    <!-- header end -->

    <!-- wrapper-box start -->
    <?php do_action( 'choicy_before_main_content' ); ?>