<?php

// DEFINE CONSTANTS
define( 'CHOICY_THEME_DIR', get_template_directory() );
define( 'CHOICY_THEME_URI', get_template_directory_uri() );
define( 'CHOICY_THEME_CSS_DIR', CHOICY_THEME_URI . '/assets/css/' );
define( 'CHOICY_THEME_JS_DIR', CHOICY_THEME_URI . '/assets/js/' );
define( 'CHOICY_THEME_INC', CHOICY_THEME_DIR . '/inc/' );
define( 'CHOICY_CORE_PLUG_DIR', plugins_url( 'choicy-core/assets/' ) );
define( 'CHOICY_CORE', in_array( 'choicy-core/choicy-core.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) );

// INCLUDE CS FRAMEWORK FILE
require CHOICY_THEME_INC . 'csf-functions.php';

if ( !defined( 'CHOICY_WOOCOMMERCE_ACTIVED' ) ) {
    define( 'CHOICY_WOOCOMMERCE_ACTIVED', in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) );
}

if ( site_url() == "https://themexriver.com/wp/choicy" OR site_url() == 'http://localhost:10089' ) {
    define( 'VERSION', time() );
} else {
    define( 'VERSION', wp_get_theme()->get( 'Version' ) );
}

if ( CHOICY_WOOCOMMERCE_ACTIVED ) {
    /**
     * Remove Action Hook
     */
    function choicy_woo_theme_init(){
        $gesto_exlude_hooks = require CHOICY_THEME_INC . 'woocommerce/woo-actions.php';
        foreach( $gesto_exlude_hooks as $k => $v )
        {
            foreach( $v as $value )
            remove_action( $k, $value[0], $value[1] );
        }

    }
    add_action( 'init', 'choicy_woo_theme_init');
}

// INCLUDE CHOICY AFTER SETUP
require CHOICY_THEME_INC . 'choicy-after-setup.php';

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function choicy_content_width() {
    // This variable is intended to be overruled from themes.
    // Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
    $GLOBALS['content_width'] = apply_filters( 'choicy_content_width', 640 );
}
add_action( 'after_setup_theme', 'choicy_content_width', 0 );

// INCLUDE CHOICY REGISTER WIDGETS
require CHOICY_THEME_INC . 'choicy-register-widgets.php';

// INCLUDE CHOICY ENQUEUE SCRIPTS
require CHOICY_THEME_INC . 'choicy-enqueue-scripts.php';

// INCLUDE CUSTOM HEADER
require CHOICY_THEME_INC . 'custom-header.php';

// INCLUDE CUSTOM FUNCTIONS FILE
require CHOICY_THEME_INC . 'choicy-functions.php';

// INCLUDE CUSTOM CSS
require CHOICY_THEME_INC . 'choicy-custom-css.php';

// INCLUDE DEFAULT COMMENT
require CHOICY_THEME_INC . 'choicy-comment.php';

// INCLUDE LOGO FILE
require CHOICY_THEME_INC . 'layouts/choicy-logos.php';

// INCLUDE MENU FILE
require CHOICY_THEME_INC . 'layouts/choicy-menus.php';

// INCLUDE DEFAULT BREADCRUMB
require CHOICY_THEME_INC . 'layouts/choicy-breadcrumb.php';

// INCLUDE ALL ACTION FILE
require CHOICY_THEME_INC . 'layouts/choicy-actions.php';

// INCLUDE DEFAULT HEADER
require CHOICY_THEME_INC . 'layouts/choicy-default-header.php';

// INCLUDE FOOTER FILE
require CHOICY_THEME_INC . 'layouts/choicy-default-footer.php';

// INCLUDE SEARCH WIDGET FILE
require CHOICY_THEME_INC . 'choicy-search-widget.php';

// LOAD JETPACK COMPATIBILITY FILE
if ( defined( 'JETPACK__VERSION' ) ) {
    require CHOICY_THEME_INC . 'jetpack.php';
}

// ALL CLASS FILE
include_once CHOICY_THEME_INC . 'classes/class-choicy-helper.php';
require_once CHOICY_THEME_INC . 'classes/class-breadcrumb.php';
require_once CHOICY_THEME_INC . 'classes/class-navwalker.php';
require_once CHOICY_THEME_INC . 'classes/class-tgm-plugin-activation.php';
require_once CHOICY_THEME_INC . 'required-plugin.php';