<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package choicy
 */

get_header();

$choicy_error_image = cs_get_option( 'tx_error_image', get_template_directory_uri() . '/assets/img/resource/error.png' );
if(isset($choicy_site_logo['url'])) {
	$image_url = $choicy_error_image['url'];
} else {
	$image_url = get_template_directory_uri() . '/assets/img/resource/error.png';
}
$choicy_error_title = cs_get_option('tx_error_title', __('Oops! Page Not found.', 'choicy'));
$choicy_error_link_text = cs_get_option('tx_error_link_text', __('Back To Home Page', 'choicy'));

?>

<section class="not-found error-one">
	<div class="auto-container">
		<?php if(!empty( $image_url )) : ?>
		<div class="image">
			<img src="<?php echo esc_url($image_url); ?>" alt="<?php if(function_exists('logo_url')) { echo choicy_img_alt_text($image_url); } ?>" />
		</div>
		<?php endif; ?>
		<h2 class="error-title"><?php print esc_html($choicy_error_title);?></h2>
		<!-- Button Box -->
		<div class="error-one_button">
			<a href="<?php echo home_url(); ?>" class="btn-style-one theme-btn">
				<div class="btn-wrap">
					<span class="text-one"><?php print esc_html($choicy_error_link_text);?>
						<i class="flaticon-arrow-pointing-to-right"></i>
					</span>
					<span class="text-two"><?php print esc_html($choicy_error_link_text);?>
						<i class="flaticon-arrow-pointing-to-right"></i>
					</span>
				</div>
			</a>
		</div>
	</div>
</section>

<?php
get_footer();
