<?php

// Control core classes for avoid errors
if ( class_exists( 'CSF' ) ) {

    CSF::createWidget( 'custom_cat_widget', [
        'title'       => 'Choicy Category Widget',
        'classname'   => 'tx-cat-widget',
        'description' => 'Widget description.',
        'fields'      => [
            [
                'id'    => 'title',
                'type'  => 'text',
                'title' => 'Title',
            ],
            [
                'id'     => 'select_cats',
                'type'   => 'repeater',
                'title'  => 'Repeater Field',
                'fields' => [
                    // select cat
                    [
                        'id'         => 'select_cat',
                        'type'       => 'select',
                        'title'      => 'Select Field',
                        'options'    => 'categories',
                        'query_args' => [
                            'taxonomy' => 'category',
                        ],
                    ],
                ],
            ],

        ],
    ] );

    if ( !function_exists( 'custom_cat_widget' ) ) {
        function custom_cat_widget( $args, $instance ) {

            echo $args['before_widget'];

            if ( !empty( $instance['title'] ) ) {
                echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
            }

            $html = '';

            if(!empty($instance['select_cats']) && is_array($instance['select_cats'])) {
                $html .= '<div class="tx-cat-widget">';
                    $html .= '<ul class="tx-cat-list sidebar-category has-number list-unstyled">';
                    foreach ( $instance['select_cats'] as $cat ) {
                        $html .= '<li class="tx-cat-item wow fadeInUp">';
                        $html .= '<a href="' . get_category_link( $cat['select_cat'] ) . '">';
                        $html .= '<span class="text">' . get_cat_name( $cat['select_cat'] ) . '</span>';
                        $count = get_category($cat['select_cat'])->count;
                        $countFormatted = ($count < 10) ? '0' . $count : $count;
                        $html .= '<span class="number">' . $countFormatted . '</span>';
                        $html .= '</a>';
                        $html .= '</li>';
                    }
                    $html .= '</ul>';
                    $html .= '</div>';
                }

            echo $html;

            echo $args['after_widget'];

        }
    }

}
