<?php

CSF::createSection( $prefix . '_theme_options', [
    'title'  => 'Preloader ON/OFF',
    'parent' => 'theme_settings',
    'priority' => 1,
    'fields' => [
        [
            'id'      => 'preloader_enable',
            'title'   => esc_html__( 'Enable Preloader', 'choicy-core' ),
            'type'    => 'switcher',
            'desc'    => esc_html__( 'Enable or Disable Preloader', 'choicy-core' ),
            'default' => true,
        ],

        // enable image preloader
        [
            'id'      => 'preloader_image_enable',
            'title'   => esc_html__( 'Enable Image Preloader', 'choicy-core' ),
            'type'    => 'switcher',
            'desc'    => esc_html__( 'Enable or Disable Image Preloader', 'choicy-core' ),
            'default' => false,
            'dependency' => ['preloader_enable', '==', 'true'],
        ],

        // preloader image
        [
            'id'       => 'preloader_image',
            'type'     => 'media',
            'title'    => esc_html__( 'Preloader Image', 'choicy-core' ),
            'desc'     => esc_html__( 'Upload Preloader Image', 'choicy-core' ),
            'default'  => [
                'url' => get_template_directory_uri() . '/assets/img/preloader.svg',
            ],
            'dependency' => ['preloader_image_enable', '==', 'true'],
        ],

        // preloader canvas background color
        [
            'id'      => 'preloader_canvas_bg_color',
            'type'    => 'color',
            'title'   => esc_html__( 'Canvas Background Color', 'choicy-core' ),
            'default' => '#000',
            'output'  => '#tx_preloader:before, #tx_preloader:after',
            'dependency' => ['preloader_enable', '==', 'true'],
            'output_mode' => 'background-color',
        ],

        // size
        [
            'id'          => 'preloader_image_width',
            'type'        => 'slider',
            'title'       => 'Width',
            'min'         => 50,
            'max'         => 300,
            'step'        => 1,
            'unit'        => 'px',
            'output'      => '#tx_preloader.has-img img',
            'output_mode' => 'max-width',
        ],
    ],
] );