<?php

CSF::createSection( $prefix . '_theme_options', [
    'title'    => esc_html__( 'Color Settings', 'choicy-core' ),
    'parent'   => 'theme_settings',
    'priority' => 2,
    'fields'   => [
        [
            'type'    => 'subheading',
            'content' => '<h3>' . esc_html__( 'Color Settings', 'choicy-core' ) . '</h3>',
        ],
        [
            'id'      => 'theme_primary_color',
            'type'    => 'color',
            'title'   => 'Theme Primary Color',
            'default' => '#A249ED',
        ],

        // theme_color 2
        [
            'id'      => 'theme_color_2',
            'type'    => 'color',
            'title'   => 'Theme Color 2',
            'default' => '#ee4619',
        ],

        // theme_color 3
        [
            'id'      => 'theme_color_3',
            'type'    => 'color',
            'title'   => 'Theme Color 3',
            'default' => '#27f67a',
        ],

        // theme_color 4
        [
            'id'      => 'theme_color_4',
            'type'    => 'color',
            'title'   => 'Theme Color 4',
            'default' => '#f28541',
        ],

        // theme_color 5
        [
            'id'      => 'theme_color_5',
            'type'    => 'color',
            'title'   => 'Theme Color 5',
            'default' => '#9255CE',
        ],

        // theme_color 6
        [
            'id'      => 'theme_color_6',
            'type'    => 'color',
            'title'   => 'Theme Color 6',
            'default' => '#7237E9',
        ],

        // theme gd 1
        [
            'id'      => 'theme_gd_color_1',
            'type'    => 'color_group',
            'title'   => 'Gradient Color One',
            'options' => [
                'color_1' => 'Color 1',
                'color_2' => 'Color 2',
            ],
            'default' => [
                'color_1' => '#a249ed',
                'color_2' => '#6131e8',
            ],
        ],

        // theme gd 2
        [
            'id'      => 'theme_gd_color_2',
            'type'    => 'color_group',
            'title'   => 'Gradient Color One',
            'options' => [
                'color_1' => 'Color 1',
                'color_2' => 'Color 2',
            ],
            'default' => [
                'color_1' => '#9255CE',
                'color_2' => '#BE60FF',
            ],
        ],

    ],
] );