<?php

CSF::createSection( $prefix . '_theme_options', [
    'title'  => esc_html__( 'Breadcrumb Layout', 'choicy-core' ),
    'parent' => 'theme_layout',
    'priority' => 3,
    'fields' => [
        [
            'type'    => 'subheading',
            'content' => '<h3>' . esc_html__( 'Breadcrumb Layout', 'choicy-core' ) . '</h3>',
        ],
        [
            'id'      => 'breadcrumb_bg_img',
            'title'   => esc_html__( 'Breadcrumb Image', 'choicy-core' ),
            'type'    => 'media',
            'desc'    => esc_html__( 'Upload breadcrumb Image', 'choicy-core' ),
            'preview_width' => '500',
            'preview_height' => '300',
        ],

        // enable breadcrumb list
        [
            'id'      => 'enable_breadcrumb_list',
            'type'    => 'switcher',
            'title'   => esc_html__( 'Enable Breadcrumb List', 'choicy-core' ),
            'default' => true,
        ],

        // breadcrub padding
        [
            'id'          => 'breadcrumb_padding',
            'type'        => 'spacing',
            'title'       => esc_html__( 'Breadcrumb Padding', 'choicy-core' ),
            'output'      => '.tx-breadcrumb',
            'output_mode' => 'padding',
            'units'       => [ 'px', 'em' ],
            'default'     => [
                'top'    => '100px',
                'right'  => '0px',
                'bottom' => '100px',
                'left'   => '0px',
            ],
        ],

    ],
] );