<div class="chy-testimonial-4-slider">
    <div class="swiper-container fix chy_testimonial_4_active">
        <div class="swiper-wrapper">

        <?php foreach($settings['testimonial_lists'] as $testimonial_list) : ?>
            <div class="swiper-slide">
                <div class="chy-testimonial-4-item">
                    <?php if( $testimonial_list['enable_icon'] === 'yes' ) : ?>
                    <div class="icon">
                        <?php if ( $testimonial_list['type'] == 'quote' ): ?>
                            <?php \Elementor\Icons_Manager::render_icon( $testimonial_list['quote_icon'], ['aria-hidden' => 'true'] );?>
                        <?php else: ?>
                            <img src="<?php echo esc_url( $testimonial_list['quote_image']['url'] ); ?>" alt="" />
                        <?php endif;?>
                    </div>
                    <?php endif; ?>

                    <div class="content-wrap">
                        <?php if(!empty( $testimonial_list['heading'] )) : ?>
                        <span class="subtitle chy-heading-1"><?php echo elh_element_kses_intermediate($testimonial_list['heading']); ?></span>
                        <?php endif; ?>

                        <?php if(!empty( $testimonial_list['comment'] )) : ?>
                        <p class="chy-heading-1 comment"><?php echo elh_element_kses_intermediate($testimonial_list['comment']); ?></p>
                        <?php endif; ?>

                        <div class="person-wrap">
                            <div class="person-img">
                            <?php if(!empty( $testimonial_list['author_image']['url'] )) : ?>
                            <img src="<?php echo esc_url($testimonial_list['author_image']['url']); ?>" alt="" />
                            <?php endif; ?>
                            </div>
                            <div class="name-wrap">
                                <?php if(!empty( $testimonial_list['name'] )) : ?>
                                <h4 class="chy-heading-1 name"><?php echo elh_element_kses_intermediate($testimonial_list['name']); ?></h4>
                                <?php endif; ?>

                                <?php if(!empty( $testimonial_list['rating_star'] )) : ?>
                                <div class="reating">
                                    <?php for($i = 1; $i <= $testimonial_list['rating_star']; $i++) : ?>
                                    <i class="fas fa-star"></i>
                                    <?php endfor; ?>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>

        </div>
    </div>

    <?php if( $settings['enable_slide_arrows'] === 'yes' ) : ?>
    <div class="chy-testimonial-4-btn">
        <div class="chy_testimonial_4_prev">
            <i class="far fa-long-arrow-left"></i>
        </div>
        <div class="chy_testimonial_4_next">
            <i class="far fa-long-arrow-right"></i>
        </div>
    </div>
    <?php endif; ?>

</div>