<div class="chy-testimonial-2-slider">
    <div class="swiper-container fix chy_testimonial_2_active">
        <div class="swiper-wrapper">

            <?php foreach($settings['testimonial_lists'] as $testimonial_list) : ?>
            <div class="swiper-slide">
                <div class="chy-testimonial-2-item">
                    <div class="main-img">
                        <?php if(!empty( $testimonial_list['author_image']['url'] )) : ?>
                        <img src="<?php echo esc_url($testimonial_list['author_image']['url']); ?>" alt="" />
                        <?php endif; ?>
                    </div>
                    <p class="chy-heading-1 comment">
                        <?php echo elh_element_kses_intermediate($testimonial_list['comment']); ?>
                    </p>
                    <div class="person-wrap">
                        <?php if( $testimonial_list['enable_icon'] === 'yes' ) : ?>
                        <div class="icon">
                            <?php if ( $testimonial_list['type'] == 'quote' ): ?>
                                <?php \Elementor\Icons_Manager::render_icon( $testimonial_list['quote_icon'], ['aria-hidden' => 'true'] );?>
                            <?php else: ?>
                                <img src="<?php echo esc_url( $testimonial_list['quote_image']['url'] ); ?>" alt="" />
                            <?php endif;?>
                        </div>
                        <?php endif; ?>
                        <div class="right">
                            <?php if(!empty( $testimonial_list['name'] )) : ?>
                            <h3 class="chy-heading-1 name">
                                <?php echo elh_element_kses_intermediate($testimonial_list['name']); ?>
                            </h3>
                            <?php endif; ?>

                            <?php if(!empty( $testimonial_list['designation'] )) : ?>
                            <p class="chy-para-2 bio">
                                <?php echo elh_element_kses_intermediate($testimonial_list['designation']); ?>
                            </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php if( $settings['enable_slide_dots'] === 'yes' ) : ?>
    <div class="chy-testimonial-2-pagination"></div>
    <?php endif; ?>
</div>