<?php

namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Background;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_Testimonial extends Element_El_Widget {

    /**
     * Slider Style Dependency
     *
     * @return void
     */
    public function get_style_depends() {
        return [ 'testimonial-5' ];
    }

    /**
     * Get widget name.
     *
     * Retrieve Choicy Core widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'tx_testimonial';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return __( 'TX Testimonial', 'choicy-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/gradient-heading/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-t-letter';
    }

    public function get_keywords() {
        return ['count', 'choicy', 'choicy testimonial', 'testimonial', 'choicy testimonial widget'];
    }

    protected function register_content_controls() {

        //Settings
        $this->start_controls_section(
            '_section_choose_style',
            [
                'label' => __( 'CHOOSE DESIGN STYLE', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'choicy-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'choicy-core' ),
                    'style_2' => __( 'Style 2', 'choicy-core' ),
                    'style_3' => __( 'Style 3', 'choicy-core' ),
                    'style_4' => __( 'Style 4', 'choicy-core' ),
                    'style_5' => __( 'Style 5', 'choicy-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_testimonial',
            [
                'label' => __( 'Testimonial', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_1', 'style_2', 'style_3', 'style_5'],
                ],
            ]
        );

        // repeater
        $repeater = new Repeater();

        // design style
        $repeater->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'choicy-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'choicy-core' ),
                    'style_2' => __( 'Style 2', 'choicy-core' ),
                    'style_3' => __( 'Style 3', 'choicy-core' ),
                    'style_5' => __( 'Style 5', 'choicy-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        // image
        $repeater->add_control(
            'bg_image',
            [
                'label'   => __( 'BG Image', 'choicy-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'design_style' => ['style_5'],
                ],
            ]
        );
        $repeater->add_control(
            'author_image',
            [
                'label'   => __( 'Author Image', 'choicy-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // heading
        $repeater->add_control(
            'sub_heading',
            [
                'label'       => __( 'Sub Heading', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your Sub heading', 'choicy-core' ),
                'default'     => __( 'John Doe', 'choicy-core' ),
                'label_block' => true,
                'condition'   => [
                    'design_style' => ['style_5'],
                ],
            ]
        );
        $repeater->add_control(
            'heading',
            [
                'label'       => __( 'Heading', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your heading', 'choicy-core' ),
                'default'     => __( 'John Doe', 'choicy-core' ),
                'label_block' => true,
                'condition'   => [
                    'design_style' => ['style_1', 'style_3', 'style_5'],
                ],
            ]
        );

        // content
        $repeater->add_control(
            'comment',
            [
                'label'       => __( 'Comment', 'choicy-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your content', 'choicy-core' ),
                'default'     => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'choicy-core' ),
            ]
        );

        // enable icon
        $repeater->add_control(
            'enable_icon',
            [
                'label'        => __( 'Enable Icon', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => ['style_2', 'style_3'],
                ],
            ]
        );

        // type
        $repeater->add_control(
            'type',
            [
                'label'          => __( 'Type', 'choicy-core' ),
                'type'           => Controls_Manager::CHOOSE,
                'label_block'    => false,
                'options'        => [
                    'quote'  => [
                        'title' => __( 'Quote', 'choicy-core' ),
                        'icon'  => 'fa fa-quote-left',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'choicy-core' ),
                        'icon'  => 'fa fa-image',
                    ],
                ],
                'default'        => 'quote',
                'toggle'         => false,
                'style_transfer' => true,
                'condition'      => [
                    'enable_icon'  => 'yes',
                    'design_style' => ['style_2', 'style_3'],
                ],
            ]
        );

        // quote icon
        $repeater->add_control(
            'quote_icon',
            [
                'label'   => __( 'Quote Icon', 'choicy-core' ),
                'type'    => Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'fas fa-quote-left',
                    'library' => 'solid',
                ],
                'condition' => [
                    'enable_icon' => 'yes',
                    'type'         => 'quote',
                    'design_style' => ['style_2', 'style_3'],
                ],
            ]
        );

        // quote image
        $repeater->add_control(
            'quote_image',
            [
                'label'       => __( 'Quote Image', 'choicy-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'condition'   => [
                    'type'         => 'image',
                    'design_style' => ['style_2', 'style_3'],
                ],
            ]
        );

        // name
        $repeater->add_control(
            'name',
            [
                'label'       => __( 'Name', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your name', 'choicy-core' ),
                'default'     => __( 'John Doe', 'choicy-core' ),
            ]
        );

        // designation
        $repeater->add_control(
            'designation',
            [
                'label'       => __( 'Designation', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your designation', 'choicy-core' ),
                'default'     => __( 'CEO', 'choicy-core' ),
                'condition' => [
                    'design_style' => ['style_1', 'style_2', 'style_5'],
                ],
            ]
        );

        $repeater->add_control(
            'rating_star',
            [
                'label'   => __( 'Rating Star', 'choicy-core' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    '1' => __( '1 Star', 'choicy-core' ),
                    '2' => __( '2 Star', 'choicy-core' ),
                    '3' => __( '3 Star', 'choicy-core' ),
                    '4' => __( '4 Star', 'choicy-core' ),
                    '5' => __( '5 Star', 'choicy-core' ),
                ],
                'default' => '5',
                'condition' => [
                    'design_style' => ['style_3'],
                ],
            ]
        );

        $this->add_control(
            'testimonial_lists',
            [
                'label'       => __( 'Testimonial Lists', 'choicy-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_testimonial_box',
            [
                'label' => __( 'Testimonial Box', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_4'],
                ],
            ]
        );

        // enable icon
        $this->add_control(
            'enable_icon',
            [
                'label'        => __( 'Enable Icon', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // type
        $this->add_control(
            'type',
            [
                'label'          => __( 'Type', 'choicy-core' ),
                'type'           => Controls_Manager::CHOOSE,
                'label_block'    => false,
                'options'        => [
                    'quote'  => [
                        'title' => __( 'Quote', 'choicy-core' ),
                        'icon'  => 'fa fa-quote-left',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'choicy-core' ),
                        'icon'  => 'fa fa-image',
                    ],
                ],
                'default'        => 'quote',
                'toggle'         => false,
                'style_transfer' => true,
                'condition'      => [
                    'enable_icon'  => 'yes',
                ],
            ]
        );

        // quote icon
        $this->add_control(
            'quote_icon',
            [
                'label'   => __( 'Quote Icon', 'choicy-core' ),
                'type'    => Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'fas fa-quote-left',
                    'library' => 'solid',
                ],
                'condition' => [
                    'enable_icon' => 'yes',
                    'type'         => 'quote',
                ],
            ]
        );

        // quote image
        $this->add_control(
            'quote_image',
            [
                'label'       => __( 'Quote Image', 'choicy-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'condition'   => [
                    'type'         => 'image',
                ],
            ]
        );

        // image
        $this->add_control(
            'author_image',
            [
                'label'   => __( 'Author Image', 'choicy-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // content
        $this->add_control(
            'comment',
            [
                'label'       => __( 'Comment', 'choicy-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your content', 'choicy-core' ),
                'default'     => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'choicy-core' ),
            ]
        );

        // name
        $this->add_control(
            'name',
            [
                'label'       => __( 'Name', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your name', 'choicy-core' ),
                'default'     => __( 'John Doe', 'choicy-core' ),
            ]
        );

        // designation
        $this->add_control(
            'designation',
            [
                'label'       => __( 'Designation', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your designation', 'choicy-core' ),
                'default'     => __( 'CEO', 'choicy-core' ),
            ]
        );


        $this->end_controls_section();

        // SETTINGS
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'Settings', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // enable slide dots
        $this->add_control(
            'enable_slide_dots',
            [
                'label'        => __( 'Enable Slide Dots', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // enable slide arrows
        $this->add_control(
            'enable_slide_arrows',
            [
                'label'        => __( 'Enable Slide Arrows', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => ['style_3'],
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function register_style_controls() {
        // testimonial box style
        $this->start_controls_section(
            '_section_style_testimonial_box',
            [
                'label' => __( 'Testimonial Box', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'shape_bg_color',
                'label'    => __( 'Background', 'choicy-core' ),
                'types'    => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '
                    {{WRAPPER}} .chy-testimonial-4-item::after
                ',
            ]
        );

        // end
        $this->end_controls_section();
    }

    protected function render() {

        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $style = !empty($settings['design_style']) ? $settings['design_style'] : 'style_1';

        switch ($style) {
            case 'style_5':
                include $dir . '/views/view-5.php';
                break;

            case 'style_4':
                include $dir . '/views/view-4.php';
                break;
            case 'style_3':
                include $dir . '/views/view-3.php';
                break;
            case 'style_2':
                include $dir . '/views/view-2.php';
                break;
            default:
                include $dir . '/views/view-1.php';
        }
    }
}
