<?php

namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Repeater;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_Team extends Element_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Choicy Core widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'tx_team';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return __( 'TX Team', 'choicy-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/gradient-heading/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-t-letter';
    }

    public function get_keywords() {
        return ['count', 'choicy', 'choicy team'];
    }

    protected function register_content_controls() {

        //Settings
        $this->start_controls_section(
            '_section_design_settings',
            [
                'label' => __( 'Choose Design Style', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'choicy-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'choicy-core' ),
                    'style_2' => __( 'Style 2', 'choicy-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        // team member
        $this->start_controls_section(
            '_section_team',
            [
                'label'     => __( 'Team Box', 'choicy-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'style_2',
                ],
            ]
        );

        $this->add_control(
            'enable_animation',
            [
                'label'        => __( 'Enable Animation', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // team image
        $this->add_control(
            'team_image',
            [
                'label'   => __( 'Team Image', 'choicy-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // name
        $this->add_control(
            'name',
            [
                'label'       => __( 'Name', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'John Doe', 'choicy-core' ),
                'placeholder' => __( 'Enter your name', 'choicy-core' ),
            ]
        );

        // designation
        $this->add_control(
            'designation',
            [
                'label'       => __( 'Designation', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'CEO', 'choicy-core' ),
                'placeholder' => __( 'Enter your designation', 'choicy-core' ),
            ]
        );

        // link
        $this->add_control(
            'link',
            [
                'label'       => __( 'Link', 'choicy-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'choicy-core' ),
                'default'     => [
                    'url' => '#',
                ],
            ]
        );

        // social links
        $repeater = new Repeater();

        $repeater->add_control(
            'social_icon',
            [
                'label'   => __( 'Icon', 'choicy-core' ),
                'type'    => Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
            ]
        );

        $repeater->add_control(
            'social_link',
            [
                'label'       => __( 'Link', 'choicy-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'choicy-core' ),
                'default'     => [
                    'url' => '#',
                ],
            ]
        );

        $this->add_control(
            'social_links',
            [
                'label'       => __( 'Social Links', 'choicy-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'social_icon' => [
                            'value'   => 'fab fa-facebook-f',
                            'library' => 'fa-brands',
                        ],
                        'social_link' => [
                            'url' => '#',
                        ],
                    ],
                    [
                        'social_icon' => [
                            'value'   => 'fab fa-twitter',
                            'library' => 'fa-brands',
                        ],
                        'social_link' => [
                            'url' => '#',
                        ],
                    ],
                    [
                        'social_icon' => [
                            'value'   => 'fab fa-linkedin-in',
                            'library' => 'fa-brands',
                        ],
                        'social_link' => [
                            'url' => '#',
                        ],
                    ],
                ],
                'title_field' => '{{{ social_icon.value }}}',
            ]
        );

        $this->end_controls_section();

        // Image Box
        $this->start_controls_section(
            '_section_image_box',
            [
                'label'     => __( 'Image Box', 'choicy-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'style_1',
                ],
            ]
        );

        // image
        $this->add_control(
            'image_1',
            [
                'label'              => __( 'Image', 'choicy-core' ),
                'type'               => Controls_Manager::MEDIA,
                'default'            => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        // image 2
        $this->add_control(
            'image_2',
            [
                'label'              => __( 'Image 2', 'choicy-core' ),
                'type'               => Controls_Manager::MEDIA,
                'default'            => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        // team list
        $this->start_controls_section(
            '_section_team_list',
            [
                'label'     => __( 'Team List', 'choicy-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'style_1',
                ],
            ]
        );

        // team list
        $repeater = new Repeater();

        // right style active
        $repeater->add_control(
            'right_style_active',
            [
                'label'        => __( 'Right Style Active', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // team image
        $repeater->add_control(
            'team_image',
            [
                'label'   => __( 'Team Image', 'choicy-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // TEAM SIDE IMAGE
        $repeater->add_control(
            'team_side_image',
            [
                'label'   => __( 'Team Side Image', 'choicy-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // name
        $repeater->add_control(
            'name',
            [
                'label'       => __( 'Name', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'John Doe', 'choicy-core' ),
                'placeholder' => __( 'Enter your name', 'choicy-core' ),
            ]
        );

        // designation
        $repeater->add_control(
            'designation',
            [
                'label'       => __( 'Designation', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'CEO', 'choicy-core' ),
                'placeholder' => __( 'Enter your designation', 'choicy-core' ),
            ]
        );

        // LINK
        $repeater->add_control(
            'link',
            [
                'label'       => __( 'Link', 'choicy-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'choicy-core' ),
                'default'     => [
                    'url' => '#',
                ],
            ]
        );

        // TWAM LISTS
        $this->add_control(
            'team_lists',
            [
                'label'       => __( 'Team Lists', 'choicy-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'team_image'  => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                        'name'        => __( 'John Doe', 'choicy-core' ),
                        'designation' => __( 'CEO', 'choicy-core' ),
                    ],
                ],
                'title_field' => '{{{ name }}}',
            ]
        );

        // END
        $this->end_controls_section();

        $this->start_controls_section(
            '_section_button',
            [
                'label'     => __( 'Button', 'choicy-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'style_1',
                ],
            ]
        );
        // enable_icon
        $this->add_control(
            'enable_icon',
            [
                'label'        => __( 'Enable Icon', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // icon
        $this->add_control(
            'button_icon',
            [
                'label'       => __( 'Icon', 'choicy-core' ),
                'type'        => Controls_Manager::ICONS,
                'label_block' => true,
                'default'     => [
                    'value'   => 'fas fa-check',
                    'library' => 'solid',
                ],
            ]
        );

        // Button text
        $this->add_control(
            'button_text',
            [
                'label'       => __( 'Button Text', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Button Text', 'choicy-core' ),
                'placeholder' => __( 'Type your title here', 'choicy-core' ),
                'label_block' => true,
            ]
        );

        // Button link
        $this->add_control(
            'button_link',
            [
                'label'         => __( 'Button Link', 'choicy-core' ),
                'type'          => Controls_Manager::URL,
                'placeholder'   => __( 'https://your-link.com', 'choicy-core' ),
                'default'       => [
                    'url' => '#',
                ],
                'show_external' => true,
                'label_block'   => false,
            ]
        );

        $this->end_controls_section();

    }

    protected function register_style_controls() {
        $dir = dirname( __FILE__ );

        $style_files = glob( $dir . '/styles/*.php' );

        if ( $style_files ) {
            foreach ( $style_files as $style_file ) {
                include $style_file;
            }
        }
    }

    protected function render() {

        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        if ( !empty( $settings['design_style'] ) && $settings['design_style'] == 'style_3' ):
            include $dir . '/views/view-3.php';

        elseif ( !empty( $settings['design_style'] ) && $settings['design_style'] == 'style_2' ):
            include $dir . '/views/view-2.php';
        else:
            include $dir . '/views/view-1.php';
        endif;
    }
}
