<?php

use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;

// BOX STYLE
$this->start_controls_section(
    '_section_style_team_box',
    [
        'label' => __( 'TEAM BOX STYLE', 'choicy-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

// BOX BG
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'team_box_bg_color',
        'label'    => __( 'Background', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector' => '
            {{WRAPPER}} .chy-team-2-item .main-img::after
        ',
    ]
);

// NAME COLOR
$this->add_control(
    'team_box_name_color',
    [
        'label'     => __( 'Name Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-team-2-item .name' => 'color: {{VALUE}};',
        ],
    ]
);

// NAME TYPOGRAPHY
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'team_box_name_typography',
        'label'    => __( 'Typography', 'choicy-core' ),
        'selector' => '{{WRAPPER}} .chy-team-2-item .name',
    ]
);

// CENTER SHPE BG
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'team_box_designation_color',
        'label'    => __( 'Center Shape Background', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector' => '
            {{WRAPPER}} .chy-team-2-item .bio
        ',
    ]
);


// DESIGNATION TYPOGRAPHY
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'team_box_designation_typography',
        'label'    => __( 'Typography', 'choicy-core' ),
        'selector' => '{{WRAPPER}} .chy-team-2-item .bio',
    ]
);

// CENTER SHPE BG
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'team_box_center_shape_bg_color',
        'label'    => __( 'Center Shape Background', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector' => '
            {{WRAPPER}} .chy-team-2-item .content-wrap
        ',
    ]
);

// END
$this->end_controls_section();