<ul class="chy-footer-3-social tx-listItems list-unstyled">
    <?php foreach( $settings['social_links'] as $list ) : ?>
    <li class="tx-label">
        <a href="<?php echo esc_url($list['social_link']['url']); ?>"
            target="<?php echo esc_attr( $list['social_link']['is_external'] ? '_blank' : '_self' ); ?>"
            rel="<?php echo esc_attr( $list['social_link']['nofollow'] ? 'nofollow' : '' ); ?>">
            <?php if( $list['enable_icon'] === 'yes' ) : ?>
            <span class="icon">
                <?php if( $list['type'] === 'icon' ) : ?>
                    <?php \Elementor\Icons_Manager::render_icon( $list['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                <?php else : ?>
                    <img src="<?php echo esc_url( $list['social_image']['url'] ); ?>" alt="<?php echo esc_attr( $list['social_image']['alt'] ); ?>">
                <?php endif; ?>
            </span>
            <?php endif; ?>
            <?php
                if ($list['enable_label'] === 'yes') {
                    echo elh_element_kses_intermediate( $list['social_label'] );
                }
            ?>
        </a>
    </li>
    <?php endforeach; ?>
</ul>