<div class="chy-project-3-slider">
    <div class="swiper-container fix chy_project_3_active">
        <div class="swiper-wrapper">

            <?php foreach($settings['service_slides'] as $list) :  ?>
            <div class="swiper-slide">
                <div class="chy-project-3-item">
                    <div class="main-img img-cover">
                        <?php if ( $list['type'] == 'icon' ): ?>
                            <?php \Elementor\Icons_Manager::render_icon( $list['info_icon'], ['aria-hidden' => 'true'] );?>
                        <?php else: ?>
                            <img src="<?php echo esc_url( $list['image']['url'] ); ?>" alt="" />
                        <?php endif;?>
                    </div>
                    <div class="content-wrap">
                        <div class="left">
                            <?php if(!empty( $list['cat_name'] )) : ?>
                            <span class="chy-heading-1 subtitle"><?php echo elh_element_kses_intermediate($list['cat_name']); ?></span>
                            <?php endif; ?>

                            <?php if(!empty( $list['title'] )) : ?>
                            <h3 class="chy-heading-1 title">
                                <a href="<?php echo esc_url($list['button_link']['url']) ?>"><?php echo elh_element_kses_intermediate($list['title']); ?></a>
                            </h3>
                            <?php endif; ?>
                        </div>

                        <?php if(!empty( $list['button_icon'] )) : ?>
                        <a aria-label="link" href="<?php echo esc_url($list['button_link']['url']) ?>" target="<?php echo esc_attr( $list['button_link']['is_external'] ? '_blank' : '_self' ); ?>" rel="<?php echo esc_attr( $list['button_link']['nofollow'] ? 'nofollow' : '' ); ?>" class="p3-btn">
                        <?php \Elementor\Icons_Manager::render_icon( $list['button_icon'], ['aria-hidden' => 'true'] );?>
                        </a>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
            <?php endforeach; ?>

        </div>
    </div>
    <?php if( $settings['enable_slide_nav'] === 'yes' ) : ?>
    <div class="chy-project-3-btn">
        <div class="chy_project_3_prev">
            <i class="far fa-long-arrow-left"></i>
        </div>
        <div class="chy_project_3_next">
            <i class="far fa-long-arrow-right"></i>
        </div>
    </div>
    <?php endif; ?>
</div>