<div class="chy-project-1-slider">
    <div class="swiper-container fix chy_project_1_active">
        <div class="swiper-wrapper">

            <?php foreach($settings['service_slides'] as $list) :  ?>
            <div class="swiper-slide">
                <div class="chy-project-1-item img-cover">
                    <?php if ( $list['type'] == 'icon' ): ?>
                        <?php \Elementor\Icons_Manager::render_icon( $list['info_icon'], ['aria-hidden' => 'true'] );?>
                    <?php else: ?>
                        <img src="<?php echo esc_url( $list['image']['url'] ); ?>" alt="" />
                    <?php endif;?>
                    <div class="content-wrap">
                        <?php if(!empty( $list['cat_name'] )) : ?>
                        <span class="chy-heading-1 subtitle">
                            <?php echo elh_element_kses_intermediate($list['cat_name']); ?>
                        </span>
                        <?php endif; ?>

                        <?php if(!empty( $list['title'] )) : ?>
                        <h4 class="chy-heading-1 title">
                            <a href="<?php echo esc_url($list['button_link']['url']) ?>">
                                <?php echo elh_element_kses_intermediate($list['title']); ?>
                            </a>
                        </h4>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>

        </div>
    </div>

    <?php if( $settings['enable_slide_nav'] === 'yes' ) : ?>
    <div class="chy-project-1-slider-btn">
        <div class="chy_project_1_prev"><i class="flaticon-left-arrow-1"></i></div>
        <div class="chy_project_1_next"><i class="flaticon-right-arrow"></i></div>
    </div>
    <?php endif; ?>

</div>