<?php foreach($settings['service_slides'] as $list) :
    if($list['enable_shadow'] === 'yes')  {
        $shadow = '';
    } else {
        $shadow = 'no-shadow';
    }
?>
<div class="position-sticky-item">
    <div class="project-page-item mb-60 <?php echo esc_attr($shadow); ?>">

        <?php if( $list['enable_icon'] === 'yes' ) : ?>
        <div class="main-img img-cover">
            <?php if ( $list['type'] == 'icon' ): ?>
                <?php \Elementor\Icons_Manager::render_icon( $list['info_icon'], ['aria-hidden' => 'true'] );?>
            <?php else: ?>
                <img src="<?php echo esc_url( $list['image']['url'] ); ?>" alt="" />
            <?php endif;?>
        </div>
        <?php endif; ?>

        <?php if(!empty( $list['count'] )) : ?>
        <span class="chy-heading-1 number"><?php echo esc_html($list['count']); ?></span>
        <?php endif; ?>

        <?php if(!empty( $list['button_link']['url'] )) : ?>
        <div class="btn-position">
            <a href="<?php echo esc_url($list['button_link']['url']); ?>" class="pp-btn" >
                <?php \Elementor\Icons_Manager::render_icon( $list['button_icon'], ['aria-hidden' => 'true'] );?>
            </a>
        </div>
        <?php endif; ?>

        <div class="content-wrap">
            <?php if(!empty( $list['description'] )) : ?>
            <span class="chy-heading-1 subtitle"><?php echo elh_element_kses_intermediate( $list['description'] ); ?></span>
            <?php endif; ?>

            <?php if(!empty( $list['title'] )) : ?>
            <h3 class="chy-heading-1 title">
                <a href="<?php echo esc_url($list['button_link']['url']); ?>">
                    <?php echo elh_element_kses_intermediate($list['title']); ?>
                </a>
            </h3>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php endforeach; ?>