<?php

use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;

// BOX STYLE
$this->start_controls_section(
    '_section_style_box_6',
    [
        'label' => __( 'BOX 6 STYLE', 'choicy-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

// BOX 1 ICON BG COLOR
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'box_6_icon_bg_color',
        'label'    => __( 'Background', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector' => '
            {{WRAPPER}} .chy-services-5-item:nth-child(6) .icon::after
        ',
    ]
);

// BOX 1 ICON SHAPE COLOR
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'box_6_icon_shape_color',
        'label'    => __( 'Background', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector' => '
            {{WRAPPER}} .chy-services-5-item:nth-child(6) .icon::after
        ',
    ]
);

// box bg color
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'box_6_bg_color',
        'label'    => __( 'Background', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector' => '
            {{WRAPPER}} .chy-services-5-item:nth-child(6)::after
        ',
    ]
);

// BOX 1 ICON COLOR
$this->add_control(
    'box_6_icon_color',
    [
        'label'     => __( 'Icon Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-services-5-item:nth-child(6) .icon i' => 'color: {{VALUE}};',
        ],
    ]
);

// BOX 1 TITLE COLOR
$this->add_control(
    'box_6_title_color',
    [
        'label'     => __( 'Title Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-services-5-item:nth-child(6) .title' => 'color: {{VALUE}};',
        ],
    ]
);

// BOX 1 TITLE TYPOGRAPHY
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'box_6_title_typography',
        'label'    => __( 'Typography', 'choicy-core' ),
        'selector' => '{{WRAPPER}} .chy-services-5-item:nth-child(6) .title',
    ]
);

// BOX 1 DESCRIPTION COLOR
$this->add_control(
    'box_6_description_color',
    [
        'label'     => __( 'Description Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-services-5-item:nth-child(6) .disc' => 'color: {{VALUE}};',
        ],
    ]
);

// BOX 1 DESCRIPTION TYPOGRAPHY
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'box_6_description_typography',
        'label'    => __( 'Typography', 'choicy-core' ),
        'selector' => '{{WRAPPER}} .chy-services-5-item:nth-child(6) .disc',
    ]
);

// BOX 1 BUTTON COLOR
$this->add_control(
    'box_6_button_color',
    [
        'label'     => __( 'Button Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-services-5-item:nth-child(6) .s5-btn' => 'color: {{VALUE}};',
        ],
    ]
);

// BOX 1 BUTTON TYPOGRAPHY
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'box_6_button_typography',
        'label'    => __( 'Typography', 'choicy-core' ),
        'selector' => '{{WRAPPER}} .chy-services-5-item:nth-child(6) .s5-btn',
    ]
);

// END
$this->end_controls_section();