<?php

use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;

// BOX STYLE
$this->start_controls_section(
    '_section_style_box',
    [
        'label' => __( 'BOX 1 STYLE', 'choicy-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

// BOX 1 ICON BG COLOR
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'box_1_icon_bg_color',
        'label'    => __( 'Background', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector' => '
            {{WRAPPER}} .chy-services-5-item .icon::after
        ',
    ]
);

// BOX 1 ICON SHAPE COLOR
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'box_1_icon_shape_color',
        'label'    => __( 'Background', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector' => '
            {{WRAPPER}} .chy-services-5-item .icon::after
        ',
    ]
);

// box bg color
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'box_1_bg_color',
        'label'    => __( 'Background', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector' => '
            {{WRAPPER}} .chy-services-5-item::after
        ',
    ]
);

// BOX 1 ICON COLOR
$this->add_control(
    'box_1_icon_color',
    [
        'label'     => __( 'Icon Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-services-5-item .icon i' => 'color: {{VALUE}};',
        ],
    ]
);

// BOX 1 TITLE COLOR
$this->add_control(
    'box_1_title_color',
    [
        'label'     => __( 'Title Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-services-5-item .title' => 'color: {{VALUE}};',
        ],
    ]
);

// BOX 1 TITLE TYPOGRAPHY
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'box_1_title_typography',
        'label'    => __( 'Typography', 'choicy-core' ),
        'selector' => '{{WRAPPER}} .chy-services-5-item .title',
    ]
);

// BOX 1 DESCRIPTION COLOR
$this->add_control(
    'box_1_description_color',
    [
        'label'     => __( 'Description Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-services-5-item .disc' => 'color: {{VALUE}};',
        ],
    ]
);

// BOX 1 DESCRIPTION TYPOGRAPHY
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'box_1_description_typography',
        'label'    => __( 'Typography', 'choicy-core' ),
        'selector' => '{{WRAPPER}} .chy-services-5-item .disc',
    ]
);

// BOX 1 BUTTON COLOR
$this->add_control(
    'box_1_button_color',
    [
        'label'     => __( 'Button Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-services-5-item .s5-btn' => 'color: {{VALUE}};',
        ],
    ]
);

// BOX 1 BUTTON TYPOGRAPHY
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'box_1_button_typography',
        'label'    => __( 'Typography', 'choicy-core' ),
        'selector' => '{{WRAPPER}} .chy-services-5-item .s5-btn',
    ]
);

// END
$this->end_controls_section();