<?php

namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_Project_Moving extends Element_El_Widget {

    /**
     * Slider Style Dependency
     *
     * @return void
     */
    public function get_style_depends() {
        return [ 'moving-project' ];
    }
    /**
     * Get widget name.
     *
     * Retrieve Element Helper widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'tx_project_moving';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return __( 'Moving Project', 'choicy-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/gradient-heading/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-t-letter';
    }

    public function get_keywords() {
        return ['btn', 'lists', 'info', 'info lists'];
    }

    protected function register_content_controls() {

        //Settings
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'Settings', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'choicy-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'choicy-core' ),
                    'style_2' => __( 'Style 2', 'choicy-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_list_items',
            [
                'label' => __( 'Project', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        // list image
        $repeater->add_control(
            'project_img',
            [
                'label'       => __( 'Project Image', 'choicy-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'title',
            [
                'label'       => __( 'Title', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Unique social marketing design', 'choicy-core' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'category',
            [
                'label'       => __( 'Category', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'marketing', 'choicy-core' ),
                'label_block' => true,
            ]
        );

        // list_link
        $repeater->add_control(
            'list_link',
            [
                'label'       => __( 'Link', 'choicy-core' ),
                'type'        => Controls_Manager::URL,
                'label_block' => true,
                'default'     => [
                    'url' => '#',
                ],
            ]
        );
        // info label
        $repeater->add_control(
            'custom_cls',
            [
                'label'       => __( 'Item Class', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $this->add_control(
            'projects',
            [
                'label'       => __( 'Projects', 'choicy-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
            ]
        );
        // info label
        $this->add_control(
            'info_label',
            [
                'label'       => __( 'Moving Text', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Info Label', 'choicy-core' ),
                'label_block' => true,
                'condition'      => [
                    'design_style' => ['style_2'],
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            '_section_style_items',
            [
                'label' => __( 'Style', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'button_bg_color',
				'types' => [ 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => '
                {{WRAPPER}} .chy-marquee-5-area,
                {{WRAPPER}} .chy-project-5-item .main-img::after
                ',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__( 'Moving BG Color ', 'choicy-core' ),
                        'description' => esc_html__( 'Choose background type and style.', 'choicy-core' ),
                        'separator' => 'before',
                    ]
                ]
			]
		);

        $this->add_control(
			'title-c',
			[
				'label' => esc_html__( 'Title Color', 'gesto-plugin' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .chy-marquee-5-wrap .title-1, .chy-marquee-5-wrap .title-2' => 'color: {{VALUE}}',
					'{{WRAPPER}} .chy-marquee-5-wrap .title-1, .chy-marquee-5-wrap .title-2' => '-webkit-text-stroke: 1px {{VALUE}}; color:{{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .chy-marquee-5-wrap .title-1, .chy-marquee-5-wrap .title-2',
			]
		);

        // sub title bg
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'sub_title_bg_color',
                'label'    => __( 'Sub Title Background', 'choicy-core' ),
                'types'    => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '
                {{WRAPPER}} .chy-project-5-item .subtitle
                ',
            ]
        );
        $this->end_controls_section();

    }

    protected function register_style_controls() {

    }

    protected function render() {

        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $style = !empty($settings['design_style']) ? $settings['design_style'] : 'style_1';

        switch ($style) {
            case 'style_3':
                include $dir . '/views/view-3.php';
                break;

            case 'style_2':
                include $dir . '/views/view-2.php';
                break;
            default:
                include $dir . '/views/view-1.php';
        }
    }
}
