<?php
    $rand = rand(1000, 9999);
?>

<ul class="nav chy-price-3-tabs-btn nav-tabs list-unstyled" id="myTab-<?php echo esc_attr($rand); ?>" role="tablist">
    <?php
        foreach ($settings['pricingTab_lists'] as $id => $list):
        $is_active = $list['is_active'] == 'yes' ? 'active' : '';
        $aria_selected = $list['is_active'] == 'yes' ? 'true' : 'false';
    ?>
    <li class="nav-item" role="presentation">
        <button
        class="nav-link <?php echo esc_attr($is_active); ?>"
        id="pricingTab-<?php echo esc_attr($id. '_' .$rand); ?>"
        data-bs-toggle="tab"
        data-bs-target="#tab-<?php echo esc_attr($id. '_' .$rand); ?>"
        type="button"
        role="tab"
        aria-controls="tab-<?php echo esc_attr($id. '_' .$rand); ?>"
        aria-selected="<?php echo esc_attr($aria_selected); ?>">
            <?php echo elh_element_kses_intermediate($list['tab_title']); ?>
        </button>
    </li>
    <?php endforeach; ?>
</ul>

<div class="tab-content" id="myTabContent-<?php echo esc_attr($rand); ?>">
    <?php
        foreach ($settings['pricingTab_lists'] as $id => $list):
        $is_active = $list['is_active'] == 'yes' ? 'show active' : '';
    ?>
    <div class="tab-pane fade <?php echo esc_attr($is_active); ?>" id="tab-<?php echo esc_attr($id. '_' .$rand); ?>" role="tabpanel" aria-labelledby="pricingTab-<?php echo esc_attr($id. '_' .$rand); ?>">
        <div class="row">
            <?php echo \ElementHelper::$elementor_instance->frontend->get_builder_content($list['template'], true); ?>
        </div>
    </div>
    <?php endforeach; ?>
</div>