<?php
    if ( $settings['enable_animation'] === 'yes' ) {
        $anim_class = 'asslideupcta ';
    } else {
        $anim_class = '';
    }

    if($settings['is_active'] === 'yes') {
        $active_class = 'active';
    } else {
        $active_class = '';
    }

    if ($settings['currency'] === 'custom') {
        $currency = $settings['currency_custom'];
    } else {
        $currency = self::get_currency_symbol($settings['currency']);
    }
?>
<div class="chy-price-3-item mb-0 <?php echo esc_attr($active_class); ?>">
    <div class="header">
        <div class="left">
            <?php if(!empty( $settings['price'] )) : ?>
            <h3 class="chy-heading-1 price"><?php echo esc_html($currency . $settings['price']); ?></h3>
            <?php endif; ?>

            <?php if(!empty( $settings['period'] )) : ?>
            <span class="monthly chy-heading-1"><?php echo esc_html($settings['period']); ?></span>
            <?php endif; ?>
        </div>
        <div class="right">
            <?php if(!empty( $settings['pricing_title'] )) : ?>
            <h4 class="title chy-heading-1"><?php echo elh_element_kses_intermediate( $settings['pricing_title'] ); ?></h4>
            <?php endif; ?>

            <?php if(!empty( $settings['pricing_short_description'] )) : ?>
            <p class="chy-para-3 disc"><?php echo elh_element_kses_intermediate( $settings['pricing_short_description'] ); ?></p>
            <?php endif; ?>
        </div>
    </div>
    <ul class="chy-price-3-item-list list-unstyled">
        <?php foreach($settings['package_feature_lists'] as $list) : ?>
        <li>
            <?php \Elementor\Icons_Manager::render_icon( $list['package_feature_icon'], [ 'aria-hidden' => 'true' ] ); ?>
            <?php echo esc_html($list['package_feature_title']);?>
        </li>
        <?php endforeach; ?>
    </ul>

    <?php if(!empty( $settings['button_text'] )) : ?>
        <a href="<?php echo esc_url($settings['button_link']['url']);?>" class="chy-pr-btn-4 mb-50 mt-35" target="<?php echo esc_attr( $settings['button_link']['is_external'] ? '_blank' : '_self' ); ?>" rel="<?php echo esc_attr( $settings['button_link']['nofollow'] ? 'nofollow' : '' ); ?>">
            <?php echo esc_html($settings['button_text']);?>
            <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
        </a>
        <?php endif; ?>

    <?php if(!empty( $settings['pricing_description'] )) : ?>
    <span class="tax chy-heading-1"><?php echo elh_element_kses_intermediate( $settings['pricing_description'] ); ?></span>
    <?php endif; ?>
</div>