<?php
    if ( $settings['enable_animation'] === 'yes' ) {
        $anim_class = 'asslideupcta ';
    } else {
        $anim_class = '';
    }

    if($settings['is_active'] === 'yes') {
        $active_class = 'active';
    } else {
        $active_class = '';
    }

    if ($settings['currency'] === 'custom') {
        $currency = $settings['currency_custom'];
    } else {
        $currency = self::get_currency_symbol($settings['currency']);
    }
?>
<div class="chyScl">
    <div class="chy-testimonial-3-item mb-0 <?php echo esc_attr($active_class); ?>">
        <?php if(!empty( $settings['count'] )) : ?>
        <span class="chy-heading-1 number"><?php echo esc_html($settings['count']); ?></span>
        <?php endif; ?>

        <div class="title-wrap">
            <?php if(!empty( $settings['pricing_title'] )) : ?>
            <h6 class="chy-para-3 subtitle"><?php echo elh_element_kses_intermediate( $settings['pricing_title'] ); ?></h6>
            <?php endif; ?>

            <?php if(!empty( $settings['pricing_short_description'] )) : ?>
            <h3 class="chy-heading-1 title">
                <a href="<?php echo esc_url($settings['button_link']['url']);?>">
                    <?php echo elh_element_kses_intermediate( $settings['pricing_short_description'] ); ?>
                </a>
            </h3>
            <?php endif; ?>

            <?php if(!empty( $settings['client_name'] )) : ?>
            <span class="chy-heading-1 bio"><?php echo elh_element_kses_intermediate( $settings['client_name'] ); ?></span> <br>
            <?php endif; ?>

            <?php if(!empty( $settings['period'] || $settings['price'] )) : ?>
            <span class="chy-heading-1 bio"><?php echo esc_html($settings['period']); ?> <?php echo esc_html($currency . $settings['price']); ?></span>
            <?php endif; ?>
        </div>

        <?php if(!empty( $settings['pricing_description'] )) : ?>
        <p class="chy-para-3 disc"><?php echo elh_element_kses_intermediate( $settings['pricing_description'] ); ?></p>
        <?php endif; ?>

        <?php if(!empty( $settings['badge_image']['url'] )) : ?>
        <img src="<?php echo esc_url($settings['badge_image']['url']); ?>" class="main-img" alt="">
        <?php endif; ?>

        <?php if(!empty( $settings['button_link']['url'] )) : ?>
        <a aria-label="link" href="<?php echo esc_url($settings['button_link']['url']);?>" class="p3-btn" target="<?php echo esc_attr( $settings['button_link']['is_external'] ? '_blank' : '_self' ); ?>" rel="<?php echo esc_attr( $settings['button_link']['nofollow'] ? 'nofollow' : '' ); ?>">
            <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
        </a>
        <?php endif; ?>
    </div>
</div>