<?php
    if ( $settings['enable_animation'] === 'yes' ) {
        $anim_class = 'asslideupcta ';
    } else {
        $anim_class = '';
    }

    if($settings['is_active'] === 'yes') {
        $active_class = 'active';
    } else {
        $active_class = '';
    }

    if ($settings['currency'] === 'custom') {
        $currency = $settings['currency_custom'];
    } else {
        $currency = self::get_currency_symbol($settings['currency']);
    }
?>
<div class="tx-pricing-box mb-0 <?php echo esc_attr($anim_class); ?>">
    <div class="chy-price-card-1-item <?php echo esc_attr($active_class); ?>">
        <div class="icon-wrap">
            <?php if(!empty( $settings['badge_image']['url'] )) : ?>
            <div class="icon">
                <img src="<?php echo esc_url($settings['badge_image']['url']); ?>" alt="">
            </div>
            <?php endif; ?>
            <h3 class="chy-heading-1 price">
                <?php echo esc_html($currency . $settings['price']); ?>
                <?php echo esc_html($settings['period']); ?>
            </h3>
        </div>
        <?php if(!empty( $settings['pricing_title'] )) : ?>
        <h6 class="chy-heading-1 title"><?php echo elh_element_kses_intermediate( $settings['pricing_title'] ); ?></h6>
        <?php endif; ?>

        <?php if(!empty( $settings['pricing_description'] )) : ?>
        <p class="chy-para-1 disc"><?php echo elh_element_kses_intermediate( $settings['pricing_description'] ); ?></p>
        <?php endif; ?>

        <?php if(!empty( $settings['button_text'] )) : ?>
        <a href="<?php echo esc_url($settings['button_link']['url']);?>" class="pc1-btn" target="<?php echo esc_attr( $settings['button_link']['is_external'] ? '_blank' : '_self' ); ?>" rel="<?php echo esc_attr( $settings['button_link']['nofollow'] ? 'nofollow' : '' ); ?>">
            <?php echo esc_html($settings['button_text']);?>
            <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
        </a>
        <?php endif; ?>

        <?php if(!empty( $settings['pricing_short_description'] )) : ?>
        <p class="chy-heading-1 date">
            <?php echo elh_element_kses_intermediate( $settings['pricing_short_description'] ); ?>
        </p>
        <?php endif; ?>

        <ul class="chy-price-card-1-item-list list-unstyled">
            <?php foreach($settings['package_feature_lists'] as $list) : ?>
            <li>
                <?php \Elementor\Icons_Manager::render_icon( $list['package_feature_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                <?php echo esc_html($list['package_feature_title']);?>
            </li>
            <?php endforeach; ?>
        </ul>
        <?php if(!empty( $settings['bottom_image']['url'] )) : ?>
        <img src="<?php echo esc_url($settings['bottom_image']['url']); ?>" alt="" class="style-icon">
        <?php endif; ?>
    </div>
</div>