<?php

namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_Pricing_Box extends Element_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Element Helper widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'tx_pricing_box';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return __( 'TX Pricing Box', 'choicy-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/gradient-heading/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-t-letter';
    }

    public function get_keywords() {
        return ['pricing', 'telnet', 'telnet pricing', 'price'];
    }

    protected function register_content_controls() {

        //Settings
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'Settings', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'choicy-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'choicy-core' ),
                    'style_2' => __( 'Style 2', 'choicy-core' ),
                    'style_3' => __( 'Style 3', 'choicy-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        // enable_animation
        $this->add_control(
            'enable_animation',
            [
                'label'        => __( 'Enable Animation', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        // is_active
        $this->add_control(
            'is_active',
            [
                'label'        => __( 'Is Active?', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_title',
            [
                'label' => __( 'Header', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // count
        $this->add_control(
            'count',
            [
                'label'       => __( 'Count', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( '01', 'choicy-core' ),
                'label_block' => true,
                'condition'   => [
                    'design_style' => 'style_2',
                ],
            ]
        );

        // badge image
        $this->add_control(
            'badge_image',
            [
                'label'       => __( 'Badge Image', 'choicy-core' ),
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
                'condition'   => [
                    'design_style' => ['style_1', 'style_2'],
                ],
            ]
        );


        // pricing header title
        $this->add_control(
            'pricing_title',
            [
                'label'       => __( 'Title', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Pricing Title', 'choicy-core' ),
                'label_block' => true,
            ]
        );

        // description
        $this->add_control(
            'pricing_description',
            [
                'label'       => __( 'Description', 'choicy-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __( 'Pricing Description', 'choicy-core' ),
                'label_block' => true,
            ]
        );

        // short description
        $this->add_control(
            'pricing_short_description',
            [
                'label'       => __( 'Short Description', 'choicy-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => __( 'Pricing Short Description', 'choicy-core' ),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_package_feature',
            [
                'label' => __( 'Package Feature', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_1', 'style_3'],
                ],
            ]
        );

        // package feature lists
        $repeater = new \Elementor\Repeater();

        // package feature icon
        $repeater->add_control(
            'package_feature_icon',
            [
                'label'       => __( 'Icon', 'choicy-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fas fa-check',
                    'library' => 'solid',
                ],
                'label_block' => true,
            ]
        );

        // package feature title
        $repeater->add_control(
            'package_feature_title',
            [
                'label'       => __( 'Title', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Feature Title', 'choicy-core' ),
                'label_block' => true,
            ]
        );

        // package feature lists
        $this->add_control(
            'package_feature_lists',
            [
                'label'       => __( 'Feature Lists', 'choicy-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'package_feature_title' => __( 'Feature Title', 'choicy-core' ),
                    ],
                    [
                        'package_feature_title' => __( 'Feature Title', 'choicy-core' ),
                    ],
                    [
                        'package_feature_title' => __( 'Feature Title', 'choicy-core' ),
                    ],
                ],
                'title_field' => '{{{ package_feature_title }}}',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            '_section_price',
            [
                'label' => __( 'Price', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // client name
        $this->add_control(
            'client_name',
            [
                'label'       => __( 'Client Name', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Client Name', 'choicy-core' ),
                'label_block' => true,
                'condition' => [
                    'design_style' => 'style_2',
                ],
            ]
        );

        $this->add_control(
            'currency',
            [
                'label' => __('Currency', 'choicy-core'),
                'type' => Controls_Manager::SELECT,
                'label_block' => false,
                'options' => [
                    '' => __('None', 'choicy-core'),
                    'baht' => '&#3647; ' . _x('Baht', 'Currency Symbol', 'choicy-core'),
                    'bdt' => '&#2547; ' . _x('BD Taka', 'Currency Symbol', 'choicy-core'),
                    'dollar' => '&#36; ' . _x('Dollar', 'Currency Symbol', 'choicy-core'),
                    'euro' => '&#128; ' . _x('Euro', 'Currency Symbol', 'choicy-core'),
                    'franc' => '&#8355; ' . _x('Franc', 'Currency Symbol', 'choicy-core'),
                    'guilder' => '&fnof; ' . _x('Guilder', 'Currency Symbol', 'choicy-core'),
                    'krona' => 'kr ' . _x('Krona', 'Currency Symbol', 'choicy-core'),
                    'lira' => '&#8356; ' . _x('Lira', 'Currency Symbol', 'choicy-core'),
                    'peseta' => '&#8359 ' . _x('Peseta', 'Currency Symbol', 'choicy-core'),
                    'peso' => '&#8369; ' . _x('Peso', 'Currency Symbol', 'choicy-core'),
                    'pound' => '&#163; ' . _x('Pound Sterling', 'Currency Symbol', 'choicy-core'),
                    'real' => 'R$ ' . _x('Real', 'Currency Symbol', 'choicy-core'),
                    'ruble' => '&#8381; ' . _x('Ruble', 'Currency Symbol', 'choicy-core'),
                    'rupee' => '&#8360; ' . _x('Rupee', 'Currency Symbol', 'choicy-core'),
                    'indian_rupee' => '&#8377; ' . _x('Rupee (Indian)', 'Currency Symbol', 'choicy-core'),
                    'shekel' => '&#8362; ' . _x('Shekel', 'Currency Symbol', 'choicy-core'),
                    'won' => '&#8361; ' . _x('Won', 'Currency Symbol', 'choicy-core'),
                    'yen' => '&#165; ' . _x('Yen/Yuan', 'Currency Symbol', 'choicy-core'),
                    'custom' => __('Custom', 'choicy-core'),
                ],
                'default' => 'dollar',
            ]
        );

        $this->add_control(
            'currency_custom',
            [
                'label' => __('Custom Symbol', 'choicy-core'),
                'type' => Controls_Manager::TEXT,
                'condition' => [
                    'currency' => 'custom',
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        // PRICE
        $this->add_control(
            'price',
            [
                'label' => __('Price', 'choicy-core'),
                'type' => Controls_Manager::TEXT,
                'default' => '9.99',
                'dynamic' => [
                    'active' => true
                ]
            ]
        );

        // PERIOD
        $this->add_control(
            'period',
            [
                'label' => __('Period', 'choicy-core'),
                'type' => Controls_Manager::TEXT,
                'default' => _x('month', 'Period', 'choicy-core'),
                'dynamic' => [
                    'active' => true
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_button',
            [
                'label' => __( 'Button', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // button text
        $this->add_control(
            'button_text',
            [
                'label'       => __( 'Text', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Button Text', 'choicy-core' ),
                'label_block' => true,
                'condition' => [
                    'design_style' => ['style_1', 'style_3'],
                ],
            ]
        );

        // button icon
        $this->add_control(
            'button_icon',
            [
                'label'       => __( 'Icon', 'choicy-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fas fa-arrow-right',
                    'library' => 'solid',
                ],
                'label_block' => true,
            ]
        );

        // button link
        $this->add_control(
            'button_link',
            [
                'label'       => __( 'Link', 'choicy-core' ),
                'type'        => Controls_Manager::URL,
                'default'     => [
                    'url' => '#',
                ],
                'label_block' => true,
            ]
        );

        // bottom image
        $this->add_control(
            'bottom_image',
            [
                'label'       => __( 'Bottom Image', 'choicy-core' ),
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
                'condition' => [
                    'design_style' => 'style_1',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function register_style_controls() {

    }

    private static function get_currency_symbol($symbol_name)
    {
        $symbols = [
            'baht' => '&#3647;',
            'bdt' => '&#2547;',
            'dollar' => '&#36;',
            'euro' => '&#128;',
            'franc' => '&#8355;',
            'guilder' => '&fnof;',
            'indian_rupee' => '&#8377;',
            'pound' => '&#163;',
            'peso' => '&#8369;',
            'peseta' => '&#8359',
            'lira' => '&#8356;',
            'ruble' => '&#8381;',
            'shekel' => '&#8362;',
            'rupee' => '&#8360;',
            'real' => 'R$',
            'krona' => 'kr',
            'won' => '&#8361;',
            'yen' => '&#165;',
        ];

        return isset($symbols[$symbol_name]) ? $symbols[$symbol_name] : '';
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        if ($settings['currency'] === 'custom') {
            $currency = $settings['currency_custom'];
        } else {
            $currency = self::get_currency_symbol($settings['currency']);
        }

        $style = !empty($settings['design_style']) ? $settings['design_style'] : 'style_1';

        switch ($style) {
            case 'style_3':
                include $dir . '/views/view-3.php';
                break;
            case 'style_2':
                include $dir . '/views/view-2.php';
                break;
            default:
                include $dir . '/views/view-1.php';
        }
    }
}
