<div class="chy-blog-3-area">
    <div class="container chy-container-1">
        <div class="row mt-none-30">

        <?php

            if($settings['choose_columns'] === 'column_1') {
                $col = 'col-md-12';
            } elseif($settings['choose_columns'] === 'column_2') {
                $col = 'col-xl-6 col-lg-6 col-md-6';
            } elseif($settings['choose_columns'] === 'column_3') {
                $col = 'col-xl-4 col-lg-6 col-md-6';
            } elseif($settings['choose_columns'] === 'column_4') {
                $col = 'col-xl-3 col-lg-6 col-md-6';
            } elseif($settings['choose_columns'] === 'column_5') {
                $col = 'col-xl-2 col-lg-6 col-md-6 col';
            } elseif($settings['choose_columns'] === 'column_6') {
                $col = 'col-xl-2 col-lg-6 col-md-6';
            } else {
                $col = 'col-xl-4 col-lg-6 col-md-6';
            }

            if (!empty($posts)):
            foreach ( $posts as $inx => $post ):
            $title = $post->post_title;

            if ( 'selected' === $settings['show_post_by'] && array_key_exists( $post->ID, $customize_title ) ) {
                $title = $customize_title[$post->ID];
            }

            $excerpt = $post->post_excerpt;
            if ( 'selected' === $settings['show_post_by'] && array_key_exists( $post->ID, $customize_text ) ) {
                $excerpt = $customize_text[$post->ID];
            }

            $thumb = get_the_post_thumbnail_url( $post->ID, 'large' );
            if ( 'selected' === $settings['show_post_by'] && array_key_exists( $post->ID, $customize_img ) && !empty( $customize_img[$post->ID]['url'] ) ) {
                $thumb = $customize_img[$post->ID]['url'];
            }

            $author_name = get_the_author_meta( 'display_name', $post->post_author );
            // aythor image
            $author_img = get_avatar_url( $post->post_author, array( 'size' => 50 ) );

            // get post categories
            $categories = get_the_category( $post->ID );
            $cat_name = '';

            if ( !empty( $categories ) ) {
                $cat_name = $categories[0]->name;
            }
            $post_by_label = $settings['post_by_label'];

            ?>
            <div class="<?php echo esc_attr($col); ?>">
                <div class="chy-blog-3-item tilt_scale mb-0 mt-30" data-tilt-max="1">
                <?php if ( 'yes' === $settings['meta'] && 'yes' === $settings['date_meta'] ): ?>
                    <?php if( $settings['enable_default_date'] === 'yes' ) : ?>
                        <span class="chy-heading-1 date">
                            <?php
                                $date_format = get_option( 'date_format' );
                                echo esc_html( get_the_date( $date_format, $post->ID ) );
                            ?>
                        </span>
                    <?php else: ?>
                        <span class="chy-heading-1 date"><?php echo get_the_date('d'); ?> <br> <?php echo get_the_date('M'); ?></span>
                    <?php endif; ?>
                <?php endif; ?>

                <?php if(!empty( $thumb && $settings['feature_image'] === 'yes' )) : ?>
                    <div class="main-img img-cover">
                        <img src="<?php echo esc_url($thumb); ?>" alt="<?php if(function_exists('tf_img_alt_text')) { echo tf_img_alt_text($thumb); } ?>">
                    </div>
                <?php endif; ?>

                    <div class="content-wrap">
                        <div class="chy-blog-3-item-meta">
                        <?php if ( 'yes' === $settings['meta'] && 'yes' === $settings['author_meta'] ): ?>
                            <span class="chy-heading-1 author"><i class="flaticon-avatar"></i> <?php echo esc_html($post_by_label . ' ' .$author_name); ?></span>
                        <?php endif; ?>

                        <?php if ( 'yes' === $settings['meta'] && 'yes' === $settings['enable_comments'] ): ?>
                            <span class="chy-heading-1 comment"><i class="flaticon-chat"></i>
                                <?php echo esc_html($post->comment_count); ?> <?php echo esc_html__('Comments', 'choicy-core'); ?></span>
                            </span>
                        <?php endif; ?>
                        </div>
                        <h5 class="chy-heading-1 title tx-title">
                            <a href="<?php echo esc_url(get_the_permalink( $post->ID )); ?>"><?php echo esc_html($title); ?></a>
                        </h5>

                        <?php if(!empty( $excerpt )) : ?>
                        <p class="chy-para-3 disc"><?php echo esc_html($excerpt); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach;
                else:
                    printf('%1$s %2$s %3$s',
                        __('No ', 'choicy-core'),
                        esc_html($settings['post_type']),
                        __('Found', 'choicy-core')
                    );
                endif;
            ?>
        </div>
    </div>
</div>