<?php

use Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;

 // post style
 $this->start_controls_section(
    '_section_style_post',
    [
        'label' => __( 'Post', 'choicy-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

// category color
$this->add_control(
    'post_category_color',
    [
        'label'     => __( 'Category Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-blog-4-item .subtitle' => 'color: {{VALUE}};',
        ],
    ]
);

// typography
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'post_category_typography',
        'selector' => '
        {{WRAPPER}} .chy-blog-4-item .subtitle
        ',
    ]
);


// title color
$this->add_control(
    'post_title_color',
    [
        'label'     => __( 'Title Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .tx-title a' => 'color: {{VALUE}};',
            '{{WRAPPER}} .tx-title' => 'color: {{VALUE}};',
        ],
    ]
);

// typography
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'post_typography',
        'selector' => '
        {{WRAPPER}} .tx-title a,
        {{WRAPPER}} .tx-title
        ',
    ]
);

// date color
$this->add_control(
    'post_date_color',
    [
        'label'     => __( 'Date Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-blog-4-item .author' => 'color: {{VALUE}};',
        ],
    ]
);

// typography
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'post_date_typography',
        'selector' => '
        {{WRAPPER}} .chy-blog-4-item .author
        ',
    ]
);

// author color
$this->add_control(
    'post_author_color',
    [
        'label'     => __( 'Author Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-blog-4-item .author span' => 'color: {{VALUE}};',
        ],
    ]
);


// end
$this->end_controls_section();