<?php

use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;

// BOX STYLE
$this->start_controls_section(
    '_section_style_post_box',
    [
        'label' => __( 'POST BOX STYLE', 'choicy-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

// category bg
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'post_box_category_bg_color',
        'label'    => __( 'Background', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector' => '
            {{WRAPPER}} .chy-blog-4-item .subtitle
        ',
    ]
);

// heading field
$this->add_control(
    'post_box_heading',
    [
        'label'     => __( 'CONTENT BOX BG COLOR', 'choicy-core' ),
        'type'      => Controls_Manager::HEADING,
    ]
);

// content box bg
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'post_box_content_bg_color',
        'label'    => __( 'Background', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector' => '
            {{WRAPPER}} .chy-blog-4-item .content-wrap .inner-div::after
        ',
    ]
);

// END
$this->end_controls_section();