<ul class="sidebar-download list-unstyled tx-listItems">
    <?php foreach( $settings['list_items'] as $list ) : ?>
    <li class="wow fadeInUp">
        <?php
            if( $list['enable_link'] === 'yes' ) :

            if($list['link_type'] === 'email') {
                $link_url = 'mailto:' . $list['list_link']['url'];
            } elseif( $list['link_type'] === 'phone' ) {
                $link_url = 'tel:' . $list['list_link']['url'];
            } else {
                $link_url = $list['list_link']['url'];
            }
        ?>
        <a href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $list['list_link']['is_external'] ? '_blank' : '_self' ); ?>" rel="<?php echo esc_attr( $list['list_link']['nofollow'] ? 'nofollow' : '' ); ?>">
            <span class="icon-1" >
                <?php if( $list['enable_icon'] === 'yes' ) : ?>
                    <?php if( $list['type'] === 'icon' ) : ?>
                        <?php \Elementor\Icons_Manager::render_icon( $list['list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    <?php else : ?>
                        <img src="<?php echo esc_url( $list['list_image']['url'] ); ?>" alt="<?php echo esc_attr( $list['list_image']['alt'] ); ?>">
                    <?php endif; ?>
                <?php endif; ?>
            </span>
            <span class="text-wrap">
                <?php if(!empty( $list['info_label'] )) : ?>
                <span class="title"><?php echo esc_html( $list['info_label'] ); ?></span>
                <?php endif; ?>

                <?php if(!empty( $list['kbps'] )) : ?>
                <span class="kbs"><?php echo esc_html( $list['kbps'] ); ?></span>
                <?php endif; ?>
            </span>
            <?php if(!empty( $list['download_icon'] )) : ?>
            <span class="icon-2" >
                <?php \Elementor\Icons_Manager::render_icon( $list['download_icon'], [ 'aria-hidden' => 'true' ] ); ?>
            </span>
            <?php endif; ?>
        </a>
        <?php else : ?>
            <span class="icon-1" >
                <?php if( $list['enable_icon'] === 'yes' ) : ?>
                    <?php if( $list['type'] === 'icon' ) : ?>
                        <?php \Elementor\Icons_Manager::render_icon( $list['list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    <?php else : ?>
                        <img src="<?php echo esc_url( $list['list_image']['url'] ); ?>" alt="<?php echo esc_attr( $list['list_image']['alt'] ); ?>">
                    <?php endif; ?>
                <?php endif; ?>
            </span>
            <span class="text-wrap">
                <?php if(!empty( $list['info_label'] )) : ?>
                <span class="title"><?php echo esc_html( $list['info_label'] ); ?></span>
                <?php endif; ?>

                <?php if(!empty( $list['kbps'] )) : ?>
                <span class="kbs"><?php echo esc_html( $list['kbps'] ); ?></span>
                <?php endif; ?>
            </span>
            <?php if(!empty( $list['download_icon'] )) : ?>
            <span class="icon-2" >
                <?php \Elementor\Icons_Manager::render_icon( $list['download_icon'], [ 'aria-hidden' => 'true' ] ); ?>
            </span>
            <?php endif; ?>
        <?php endif; ?>
    </li>
    <?php endforeach; ?>
</ul>