<?php

namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;

defined( 'ABSPATH' ) || die();

class Tx_Link_Lists extends Element_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Element Helper widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'tx_link_lists';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return __( 'TX Lists Link', 'choicy-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/gradient-heading/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-t-letter';
    }

    public function get_keywords() {
        return ['btn', 'lists', 'info', 'info lists'];
    }

    protected function register_content_controls() {

        //Settings
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'Settings', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'choicy-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1'  => __( 'Style 1', 'choicy-core' ),
                    'style_2'  => __( 'Style 2', 'choicy-core' ),
                    'style_3'  => __( 'Style 3', 'choicy-core' ),
                    'style_4'  => __( 'Style 4', 'choicy-core' ),
                    'style_5'  => __( 'Style 5', 'choicy-core' ),
                    'style_6'  => __( 'Style 6', 'choicy-core' ),
                    'style_7'  => __( 'Style 7', 'choicy-core' ),
                    'style_8'  => __( 'Style 8', 'choicy-core' ),
                    'style_9'  => __( 'Style 9', 'choicy-core' ),
                    'style_10' => __( 'Style 10', 'choicy-core' ),
                    'style_11' => __( 'Style 11', 'choicy-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_list_items',
            [
                'label' => __( 'List Items', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        // info label
        $this->add_control(
            'list_title',
            [
                'label'       => __( 'List Title', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Companies', 'choicy-core' ),
                'label_block' => true,
                'condition'   => [
                    'design_style' => 'style_11',
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        // design style
        $repeater->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'choicy-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1'  => __( 'Style 1', 'choicy-core' ),
                    'style_2'  => __( 'Style 2', 'choicy-core' ),
                    'style_3'  => __( 'Style 3', 'choicy-core' ),
                    'style_4'  => __( 'Style 4', 'choicy-core' ),
                    'style_5'  => __( 'Style 5', 'choicy-core' ),
                    'style_6'  => __( 'Style 6', 'choicy-core' ),
                    'style_7'  => __( 'Style 7', 'choicy-core' ),
                    'style_8'  => __( 'Style 8', 'choicy-core' ),
                    'style_10' => __( 'Style 10', 'choicy-core' ),
                    'style_11' => __( 'Style 11', 'choicy-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        // enable_icon
        $repeater->add_control(
            'enable_icon',
            [
                'label'        => __( 'Enable Icon', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $repeater->add_control(
            'type',
            [
                'label'          => __( 'List Icon', 'choicy-core' ),
                'type'           => Controls_Manager::CHOOSE,
                'label_block'    => false,
                'options'        => [
                    'icon'  => [
                        'title' => __( 'Icon', 'choicy-core' ),
                        'icon'  => 'far fa-smile',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'choicy-core' ),
                        'icon'  => 'fa fa-image',
                    ],
                ],
                'default'        => 'icon',
                'toggle'         => false,
                'style_transfer' => true,
                'condition'      => [
                    'enable_icon' => 'yes',
                ],
            ]
        );

        // list icon
        $repeater->add_control(
            'list_icon',
            [
                'label'       => __( 'Icon', 'choicy-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fas fa-check',
                    'library' => 'solid',
                ],
                'label_block' => true,
                'condition'   => [
                    'type'        => 'icon',
                    'enable_icon' => 'yes',
                ],
            ]
        );

        // list image
        $repeater->add_control(
            'list_image',
            [
                'label'       => __( 'Image', 'choicy-core' ),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'condition'   => [
                    'type'        => 'image',
                    'enable_icon' => 'yes',
                ],
            ]
        );

        // info label
        $repeater->add_control(
            'info_label',
            [
                'label'       => __( 'Info Label', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Info Label', 'choicy-core' ),
                'label_block' => true,
            ]
        );

        // enable link
        $repeater->add_control(
            'enable_link',
            [
                'label'        => __( 'Enable Link', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $repeater->add_control(
            'link_type',
            [
                'label'          => __( 'Choose Link Type', 'choicy-core' ),
                'type'           => Controls_Manager::CHOOSE,
                'label_block'    => false,
                'options'        => [
                    'url'   => [
                        'title' => __( 'URL', 'choicy-core' ),
                        'icon'  => 'far fa-globe',
                    ],
                    'email' => [
                        'title' => __( 'Email', 'choicy-core' ),
                        'icon'  => 'fa fa-envelope',
                    ],
                    'phone' => [
                        'title' => __( 'Phone', 'choicy-core' ),
                        'icon'  => 'fa fa-phone',
                    ],
                ],
                'default'        => 'icon',
                'toggle'         => false,
                'style_transfer' => true,
                'condition'      => [
                    'enable_link' => 'yes',
                ],
            ]
        );

        // list_link
        $repeater->add_control(
            'list_link',
            [
                'label'       => __( 'Link', 'choicy-core' ),
                'type'        => Controls_Manager::URL,
                'label_block' => true,
                'default'     => [
                    'url' => '#',
                ],
                'condition'   => [
                    'enable_link' => 'yes',
                ],
            ]
        );

        // kbps
        $repeater->add_control(
            'kbps',
            [
                'label'       => __( 'Kbps', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( '250kb', 'choicy-core' ),
                'label_block' => true,
                'condition'   => [
                    'design_style' => 'style_8',
                ],
            ]
        );
        $repeater->add_control(
            'animation_speed',
            [
                'label'       => __( 'Animation Speed', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( '0s', 'choicy-core' ),
                'label_block' => true,
                'condition'   => [
                    'design_style' => 'style_10',
                ],
            ]
        );

        $repeater->add_control(
            'download_icon',
            [
                'label'       => __( 'Icon', 'choicy-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fas fa-check',
                    'library' => 'solid',
                ],
                'label_block' => true,
                'condition'   => [
                    'design_style' => 'style_8',
                ],
            ]
        );

        $this->add_control(
            'list_items',
            [
                'label'       => __( 'Info Lists', 'choicy-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'info_label' => __( 'Info Text', 'choicy-core' ),
                    ],
                ],
                'title_field' => '{{{ info_label }}}',
            ]
        );

        $this->end_controls_section();

    }

    protected function register_style_controls() {

        // count style
        $this->start_controls_section(
            '_section_label_style',
            [
                'label' => __( 'Icon Style', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        // icon color
        $this->add_control(
            'icon_color',
            [
                'label'     => __( 'Icon Color', 'choicy-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-listItems i' => 'color: {{VALUE}};',
                ],
            ]
        );

        // icon bg color
        $this->add_control(
            'icon_bg_color',
            [
                'label'     => __( 'Icon Background Color', 'choicy-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-listItems i' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        // count end
        $this->end_controls_section();

        // text style
        $this->start_controls_section(
            '_section_text_style',
            [
                'label' => __( 'Text', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        // margin bottom
        $this->add_responsive_control(
            'text_margin_bottom',
            [
                'label'      => __( 'Margin Bottom', 'choicy-core' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                    '%'  => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                    'em' => [
                        'min'  => 0,
                        'max'  => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .tx-listItems li:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // text color
        $this->add_control(
            'text_color',
            [
                'label'     => __( 'Color', 'choicy-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-listItems li'   => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tx-listItems li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        // bottom border color
        $this->add_control(
            'bottom_border_color',
            [
                'label'     => __( 'Bottom Border Color', 'choicy-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-listItems li::after' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .tx-listItems a::after'  => 'background: {{VALUE}};',
                ],
            ]
        );

        // hover color
        $this->add_control(
            'hover_color',
            [
                'label'     => __( 'Hover Color', 'choicy-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-listItems li:hover'   => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tx-listItems li:hover a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .tx-listItems li::after'  => 'background: {{VALUE}};',
                    '{{WRAPPER}} .tx-listItems a::after'   => 'background: {{VALUE}};',
                ],
            ]
        );

        // hover border color
        $this->add_control(
            'hover_border_color',
            [
                'label'     => __( 'Hover Border Color', 'choicy-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tx-listItems li:hover::after' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .tx-listItems li:hover a::after'  => 'background: {{VALUE}};',
                ],
            ]
        );

        // text typography
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'text_typography',
                'label'    => __( 'Typography', 'choicy-core' ),
                'selector' => '
                {{WRAPPER}} .tx-listItems li,
                {{WRAPPER}} .tx-listItems li a
                ',
            ]
        );

        // text end
        $this->end_controls_section();
    }

    protected function render() {

        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $style = !empty( $settings['design_style'] ) ? $settings['design_style'] : 'style_1';

        switch ( $style ) {

        case 'style_11':
            include $dir . '/views/view-11.php';
            break;

        case 'style_10':
            include $dir . '/views/view-10.php';
            break;

        case 'style_9':
            include $dir . '/views/view-9.php';
            break;
        case 'style_8':
            include $dir . '/views/view-8.php';
            break;
        case 'style_7':
            include $dir . '/views/view-7.php';
            break;
        case 'style_6':
            include $dir . '/views/view-6.php';
            break;
        case 'style_5':
            include $dir . '/views/view-5.php';
            break;
        case 'style_4':
            include $dir . '/views/view-4.php';
            break;
        case 'style_3':
            include $dir . '/views/view-3.php';
            break;
        case 'style_2':
            include $dir . '/views/view-2.php';
            break;
        default:
            include $dir . '/views/view-1.php';
        }
    }
}
