<?php
 if($settings['is_active'] === 'yes') {
     $is_active = 'active';
 } else {
     $is_active = '';
 }

 if($settings['has_black_bg'] === 'yes') {
     $has_black_bg = 'has-black';
 } else {
     $has_black_bg = '';
 }

?>
<div class="chy-services-4-item tx-serviceBox tx-infoBox <?php echo esc_attr($has_black_bg . ' ' . $is_active); ?>">
    <?php if ( $settings['info_big_image']['url'] ): ?>
    <div class="main-img">
        <div class="rotatedscal img-cover">
            <img src="<?php echo esc_url( $settings['info_big_image']['url'] ); ?>" alt="" />
        </div>
    </div>
    <?php endif;?>

    <?php if ( !empty( $settings['title'] ) ): ?>
    <h4 class="chy-heading-1 title tx-title"><?php echo elh_element_kses_intermediate( $settings['title'] ); ?></h4>
    <?php endif;?>

    <?php if ( !empty( $settings['description'] ) ): ?>
    <p class="chy-para-3 disc tx-description"><?php echo elh_element_kses_intermediate( $settings['description'] ); ?></p>
    <?php endif;?>

    <?php if ( $settings['enable_feature_list'] === 'yes' ): ?>
    <ul class="chy-services-4-item-list mb-30 list-unstyled">
        <?php foreach ( $settings['feature_lists'] as $list ): ?>
        <li>
            <?php \Elementor\Icons_Manager::render_icon( $list['feature_icon'], ['aria-hidden' => 'true'] );?>
            <?php echo elh_element_kses_intermediate( $list['feature_title'] ); ?>
        </li>
        <?php endforeach;?>
    </ul>
    <?php endif;?>

    <?php if ( $settings['enable_button'] === 'yes' ): ?>
    <a href="<?php echo $settings['button_link']['url'] ? esc_url( $settings['button_link']['url'] ) : ''; ?>" class="s4-btn mt-30 ml-0">
        <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], ['aria-hidden' => 'true'] );?>
    </a>
    <?php endif;?>
</div>