<?php
    if ( $settings['enable_animation'] === 'yes' ) {
        $anim_class = 'asslideupcta ';
    } else {
        $anim_class = '';
    }
?>
<div class="chy-services-2-item tx-infoBox <?php echo esc_attr($anim_class); ?>">
    <div class="tilt_scale">
        <?php if ( $settings['enable_icon'] === 'yes' ): ?>
        <div class="icon">
            <?php if ( $settings['type'] == 'icon' ): ?>
                <?php \Elementor\Icons_Manager::render_icon( $settings['info_icon'], ['aria-hidden' => 'true'] );?>
            <?php else: ?>
                <img src="<?php echo esc_url( $settings['info_image']['url'] ); ?>" alt="" />
            <?php endif;?>
        </div>
        <?php endif;?>

        <?php if ( !empty( $settings['title'] ) ): ?>
        <h5 class="chy-heading-1 title tx-title">
            <a href="<?php echo $settings['button_link']['url'] ? esc_url( $settings['button_link']['url'] ) : ''; ?>">
                <?php echo elh_element_kses_intermediate( $settings['title'] ); ?>
            </a>
        </h5>
        <?php endif;?>

        <?php if ( !empty( $settings['description'] ) ): ?>
        <p class="chy-para-2 disc tx-description"><?php echo elh_element_kses_intermediate( $settings['description'] ); ?></p>
        <?php endif;?>
    </div>
</div>