<?php
    if ( $settings['enable_animation'] === 'yes' ) {
        $anim_class = $settings['anim_name'];
    } else {
        $anim_class = '';
    }
?>
<div class="chy-research-1-item m-0 tx-infoBox <?php echo esc_attr($anim_class); ?>">
    <div class="main-img">
        <?php if(!empty( $settings['info_big_image']['url'] )) : ?>
        <img src="<?php echo esc_url( $settings['info_big_image']['url'] ); ?>" alt="">
        <?php endif; ?>

        <?php if ( $settings['enable_icon'] === 'yes' ): ?>
        <div class="icon">
            <?php if ( $settings['type'] == 'icon' ): ?>
                <?php \Elementor\Icons_Manager::render_icon( $settings['info_icon'], ['aria-hidden' => 'true'] );?>
            <?php else: ?>
                <img src="<?php echo esc_url( $settings['info_image']['url'] ); ?>" alt="" />
            <?php endif;?>
        </div>
        <?php endif;?>
    </div>

    <?php if ( !empty( $settings['title'] ) ): ?>
    <h5 class="chy-heading-1 title tx-title"><?php echo elh_element_kses_intermediate( $settings['title'] ); ?></h5>
    <?php endif;?>

    <?php if ( !empty( $settings['description'] ) ): ?>
    <p class="chy-para-1 disc tx-description"><?php echo elh_element_kses_intermediate( $settings['description'] ); ?></p>
    <?php endif;?>
</div>