<?php
    if ( $settings['enable_animation'] === 'yes' ) {
        $anim_class = 'asslideupcta ';
    } else {
        $anim_class = '';
    }
?>
<div class="chy-services-1-item tx-infoBox <?php echo esc_attr($anim_class); ?>">
    <div class="header">
        <?php if ( $settings['enable_icon'] === 'yes' ): ?>
        <div class="icon">
            <?php if ( $settings['type'] == 'icon' ): ?>
                <?php \Elementor\Icons_Manager::render_icon( $settings['info_icon'], ['aria-hidden' => 'true'] );?>
            <?php else: ?>
                <img src="<?php echo esc_url( $settings['info_image']['url'] ); ?>" alt="" />
            <?php endif;?>
        </div>
        <?php endif;?>
        <?php if ( !empty( $settings['title'] ) ): ?>
        <h4 class="chy-heading-1 title tx-title"><?php echo elh_element_kses_intermediate( $settings['title'] ); ?></h4>
        <?php endif;?>

        <?php if ( !empty( $settings['description'] ) ): ?>
        <p class="chy-para-1 disc tx-description"><?php echo elh_element_kses_intermediate( $settings['description'] ); ?></p>
        <?php endif;?>
    </div>
    <div class="body">
        <?php if ( $settings['enable_feature_list'] === 'yes' ): ?>
        <ul class="chy-services-1-item-list list-unstyled">
            <?php foreach ( $settings['feature_lists'] as $list ): ?>
            <li>
                <?php \Elementor\Icons_Manager::render_icon( $list['feature_icon'], ['aria-hidden' => 'true'] );?>
                <?php echo elh_element_kses_intermediate( $list['feature_title'] ); ?>
            </li>
            <?php endforeach;?>
        </ul>
        <?php endif;?>

        <?php if ( $settings['enable_button'] === 'yes' ): ?>
        <a href="<?php echo $settings['button_link']['url'] ? esc_url( $settings['button_link']['url'] ) : ''; ?>" class="s1-btn">
            <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], ['aria-hidden' => 'true'] );?>
        </a>
        <?php endif;?>
    </div>
</div>