<?php
namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_Info_Box extends Element_El_Widget {
    /**
     * Slider Style Dependency
     *
     * @return void
     */
    public function get_style_depends() {
        return [ 'infobox-ten' ];
    }
    /**
     * Get widget name.
     *
     * Retrieve Choicy Core widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'tx_info_box';
    }

    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Tx Info Box', 'choicy-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/icon-box/';
    }

    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-preview-medium';
    }

    public function get_keywords() {
        return ['service', 'gird', 'icon'];
    }

    public function elh_custom_animations() {
        return [
            'none'             => __( 'None', 'telnet-core' ),
            'chy-slideinleft'  => __( 'Slide In Left', 'telnet-core' ),
            'chy-slideinright' => __( 'Slide In Right', 'telnet-core' ),
            'chy-slideinup'    => __( 'Slide In Up', 'telnet-core' ),
        ];
    }

    public function elh_element_animations() {
        return [
            'none'              => __( 'None', 'telnet-core' ),
            'fadeIn'            => __( 'Fade In', 'telnet-core' ),
            'fadeInUp'          => __( 'Fade In Up', 'telnet-core' ),
            'fadeInDown'        => __( 'Fade In Down', 'telnet-core' ),
            'fadeInLeft'        => __( 'Fade In Left', 'telnet-core' ),
            'fadeInRight'       => __( 'Fade In Right', 'telnet-core' ),
            'fadeInUpBig'       => __( 'Fade In Up Big', 'telnet-core' ),
            'fadeInDownBig'     => __( 'Fade In Down Big', 'telnet-core' ),
            'fadeInLeftBig'     => __( 'Fade In Left Big', 'telnet-core' ),
            'fadeInRightBig'    => __( 'Fade In Right Big', 'telnet-core' ),
            'bounceIn'          => __( 'Bounce In', 'telnet-core' ),
            'bounceInUp'        => __( 'Bounce In Up', 'telnet-core' ),
            'bounceInDown'      => __( 'Bounce In Down', 'telnet-core' ),
            'bounceInLeft'      => __( 'Bounce In Left', 'telnet-core' ),
            'bounceInRight'     => __( 'Bounce In Right', 'telnet-core' ),
            'rotateIn'          => __( 'Rotate In', 'telnet-core' ),
            'rotateInUpLeft'    => __( 'Rotate In Up Left', 'telnet-core' ),
            'rotateInDownLeft'  => __( 'Rotate In Down Left', 'telnet-core' ),
            'rotateInUpRight'   => __( 'Rotate In Up Right', 'telnet-core' ),
            'rotateInDownRight' => __( 'Rotate In Down Right', 'telnet-core' ),
            'lightSpeedIn'      => __( 'Light Speed In', 'telnet-core' ),
            'rollIn'            => __( 'Roll In', 'telnet-core' ),
            'zoomIn'            => __( 'Zoom In', 'telnet-core' ),
            'zoomInUp'          => __( 'Zoom In Up', 'telnet-core' ),
            'zoomInDown'        => __( 'Zoom In Down', 'telnet-core' ),
            'zoomInLeft'        => __( 'Zoom In Left', 'telnet-core' ),
            'zoomInRight'       => __( 'Zoom In Right', 'telnet-core' ),
            'slideInUp'         => __( 'Slide In Up', 'telnet-core' ),
            'slideInDown'       => __( 'Slide In Down', 'telnet-core' ),
            'slideInLeft'       => __( 'Slide In Left', 'telnet-core' ),
            'slideInRight'      => __( 'Slide In Right', 'telnet-core' ),
        ];
    }

    protected function register_content_controls() {

        $this->start_controls_section(
            '_section_design_title',
            [
                'label' => __( 'Design Style', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'choicy-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'choicy-core' ),
                    'style_2' => __( 'Style 2', 'choicy-core' ),
                    'style_3' => __( 'Style 3', 'choicy-core' ),
                    'style_4' => __( 'Style 4', 'choicy-core' ),
                    'style_5' => __( 'Style 5', 'choicy-core' ),
                    'style_6' => __( 'Style 6', 'choicy-core' ),
                    'style_7' => __( 'Style 7', 'choicy-core' ),
                    'style_8' => __( 'Style 8', 'choicy-core' ),
                    'style_9' => __( 'Style 9', 'choicy-core' ),
                    'style_10' => __( 'Style 10', 'choicy-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        // SERVICES
        $this->start_controls_section(
            '_section_info_box',
            [
                'label' => __( 'Info Box', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // is_active
        $this->add_control(
            'is_active',
            [
                'label'        => __( 'Active', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => [
                        'style_5',
                    ],
                ],
            ]
        );

        // switch_style
        $this->add_control(
            'switch_style',
            [
                'label'        => __( 'Switch Style', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'no',
                'condition'    => [
                    'design_style' => [
                        'style_9',
                    ],
                ],
            ]
        );

        // has_black_bg
        $this->add_control(
            'has_black_bg',
            [
                'label'        => __( 'Black Background?', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'no',
                'condition'    => [
                    'design_style' => [
                        'style_5',
                    ],
                ],
            ]
        );

        // enable_icon
        $this->add_control(
            'enable_icon',
            [
                'label'        => __( 'Enable Icon', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => [
                        'style_1',
                        'style_2',
                        'style_3',
                        'style_4',
                        'style_6',
                        'style_7',
                        'style_8',
                        'style_9',
                        'style_10',
                    ],
                ],
            ]
        );

        $this->add_control(
            'type',
            [
                'label'          => __( 'Service Icon', 'choicy-core' ),
                'type'           => Controls_Manager::CHOOSE,
                'label_block'    => false,
                'options'        => [
                    'icon'  => [
                        'title' => __( 'Icon', 'choicy-core' ),
                        'icon'  => 'far fa-smile',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'choicy-core' ),
                        'icon'  => 'fa fa-image',
                    ],
                ],
                'default'        => 'icon',
                'toggle'         => false,
                'style_transfer' => true,
                'condition'      => [
                    'enable_icon'  => 'yes',
                    'design_style' => [
                        'style_1',
                        'style_2',
                        'style_3',
                        'style_4',
                        'style_6',
                        'style_7',
                        'style_8',
                        'style_9',
                        'style_10',
                    ],
                ],
            ]
        );

        $this->add_control(
            'info_image',
            [
                'label'     => __( 'Service Icon', 'choicy-core' ),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'type'         => 'image',
                    'enable_icon'  => 'yes',
                    'design_style' => [
                        'style_1',
                        'style_2',
                        'style_3',
                        'style_4',
                        'style_6',
                        'style_7',
                        'style_8',
                        'style_9',
                        'style_10',
                    ],
                ],
                'dynamic'   => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'info_icon',
            [
                'type'             => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'label_block'      => true,
                'default'          => [
                    'value'   => 'fal fa-long-arrow-right',
                    'library' => 'fa-solid',
                ],
                'condition'        => [
                    'type'         => 'icon',
                    'enable_icon'  => 'yes',
                    'design_style' => [
                        'style_1',
                        'style_2',
                        'style_3',
                        'style_4',
                        'style_6',
                        'style_7',
                        'style_8',
                        'style_9',
                        'style_10',
                    ],
                ],
            ]
        );

        // info big image
        $this->add_control(
            'info_big_image',
            [
                'label'     => __( 'Service Big Image', 'choicy-core' ),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'design_style' => ['style_2', 'style_5'],
                ],
                'dynamic'   => [
                    'active' => true,
                ],
            ]
        );

        // count
        $this->add_control(
            'count',
            [
                'label'       => __( 'Count', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( '01', 'choicy-core' ),
                'placeholder' => __( 'Type Count', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'design_style' => ['style_7'],
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Service Title', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( 'Service title', 'choicy-core' ),
                'placeholder' => __( 'Type Icon Box Title', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // short_description
        $this->add_control(
            'description',
            [
                'label'       => __( 'Description', 'choicy-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default'     => __( 'Description', 'choicy-core' ),
                'placeholder' => __( 'Type Description', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'design_style' => [
                        'style_1',
                        'style_2',
                        'style_3',
                        'style_5',
                        'style_6',
                        'style_7',
                        'style_8',
                        'style_9',
                        'style_10',
                    ],
                ],
            ]
        );

        // button_link
        $this->add_control(
            'button_link',
            [
                'label'       => __( 'Button Link', 'choicy-core' ),
                'type'        => Controls_Manager::URL,
                'label_block' => true,
                'default'     => [
                    'url' => '#',
                ],
                'placeholder' => __( 'https://your-link.com', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // button icon
        $this->add_control(
            'button_icon',
            [
                'type'             => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'label_block'      => true,
                'default'          => [
                    'value'   => 'fal fa-long-arrow-right',
                    'library' => 'fa-solid',
                ],
                'condition'        => [
                    'design_style' => ['style_1', 'style_5', 'style_7', 'style_8'],
                ],
            ]
        );

        $this->end_controls_section();

        // feature lists
        $this->start_controls_section(
            '_section_feature_lists',
            [
                'label'     => __( 'Feature Lists', 'choicy-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'enable_feature_list' => 'yes',
                    'design_style'        => ['style_1', 'style_5'],
                ],
            ]
        );

        $repeater = new Repeater();

        // FEATURE ICON
        $repeater->add_control(
            'feature_icon',
            [
                'label'            => __( 'Feature Icon', 'choicy-core' ),
                'type'             => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'label_block'      => true,
                'default'          => [
                    'value'   => 'fal fa-long-arrow-right',
                    'library' => 'fa-solid',
                ],
            ]
        );

        // FEATURE TITLE
        $repeater->add_control(
            'feature_title',
            [
                'label'       => __( 'Feature Title', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( 'Feature Title', 'choicy-core' ),
                'placeholder' => __( 'Type Feature Title', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // LIST
        $this->add_control(
            'feature_lists',
            [
                'label'       => __( 'Feature Lists', 'choicy-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'feature_title' => __( 'Feature Title', 'choicy-core' ),
                    ],
                    [
                        'feature_title' => __( 'Feature Title', 'choicy-core' ),
                    ],
                    [
                        'feature_title' => __( 'Feature Title', 'choicy-core' ),
                    ],
                ],
                'title_field' => '{{{ feature_title }}}',
            ]
        );

        // END
        $this->end_controls_section();

        // SETTINGS
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'Settings', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // enable animation
        $this->add_control(
            'enable_animation',
            [
                'label'        => __( 'Enable Animation', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // select animation
        $this->add_control(
            'anim_name',
            [
                'label'       => __( 'Select Animation', 'choicy-core' ),
                'type'        => Controls_Manager::SELECT,
                'options'     => $this->elh_custom_animations(),
                'default'     => 'none',
                'label_block' => true,
                'condition'   => [
                    'enable_animation' => 'yes',
                    'design_style'     => [
                        'style_1',
                        'style_2',
                        'style_3',
                    ],
                ],
            ]
        );

        // select animation
        $this->add_control(
            'element_anim_name',
            [
                'label'       => __( 'Select Animation', 'choicy-core' ),
                'type'        => Controls_Manager::SELECT,
                'options'     => $this->elh_element_animations(),
                'default'     => 'none',
                'label_block' => true,
                'condition'   => [
                    'enable_animation' => 'yes',
                    'design_style'     => [
                        'style_4',
                    ],
                ],
            ]
        );

        // animation delay
        $this->add_control(
            'anim_delay',
            [
                'label'     => __( 'Animation Delay', 'choicy-core' ),
                'type'      => Controls_Manager::TEXT,
                'default'   => '0',
                'condition' => [
                    'enable_animation' => 'yes',
                ],
            ]
        );

        // ENABLE FEATURE LIST
        $this->add_control(
            'enable_feature_list',
            [
                'label'        => __( 'Enable Feature List', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => ['style_1', 'style_5'],
                ],
            ]
        );

        // ENABLE BUTTON
        $this->add_control(
            'enable_button',
            [
                'label'        => __( 'Enable Button', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => ['style_1', 'style_5'],
                ],
            ]
        );

        // END
        $this->end_controls_section();
    }

    protected function register_style_controls() {
        $dir = dirname( __FILE__ );

        $style_files = glob( $dir . '/styles/*.php' );

        if ( $style_files ) {
            foreach ( $style_files as $style_file ) {
                include $style_file;
            }
        }
    }

    /**
     * Render widget output on the frontend.
     *
     * Used to generate the final HTML displayed on the frontend.
     *
     * Note that if skin is selected, it will be rendered by the skin itself,
     * not the widget.
     *
     * @since 1.0.0
     * @access public
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $style = !empty( $settings['design_style'] ) ? $settings['design_style'] : 'style_1';

        switch ( $style ) {

        case 'style_10':
            include $dir . '/views/view-10.php';
            break;

        case 'style_9':
            include $dir . '/views/view-9.php';
            break;
        case 'style_8':
            include $dir . '/views/view-8.php';
            break;
        case 'style_7':
            include $dir . '/views/view-7.php';
            break;
        case 'style_6':
            include $dir . '/views/view-6.php';
            break;
        case 'style_5':
            include $dir . '/views/view-5.php';
            break;
        case 'style_4':
            include $dir . '/views/view-4.php';
            break;
        case 'style_3':
            include $dir . '/views/view-3.php';
            break;
        case 'style_2':
            include $dir . '/views/view-2.php';
            break;
        default:
            include $dir . '/views/view-1.php';
        }
    }

}