<?php

use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;

// icon style
$this->start_controls_section(
    '_section_style_icon',
    [
        'label' => __( 'ICON STYLE', 'choicy-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

// icon bg color
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'icon_bg_color',
        'label'    => __( 'Background', 'choicy-core' ),
        'types'    => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector' => '
            {{WRAPPER}} .tx-listItems .icon,
            {{WRAPPER}} .tx-infoBox .icon,
        ',
    ]
);

//icon color
$this->add_control(
    'icon_color',
    [
        'label'     => __( 'Icon Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .tx-listItems .icon' => 'color: {{VALUE}};',
            '{{WRAPPER}} .tx-infoBox .icon' => 'color: {{VALUE}};',
        ],
    ]
);

// end
$this->end_controls_section();