<?php

use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;

// box style
$this->start_controls_section(
    '_section_style_box',
    [
        'label' => __( 'Box Style', 'choicy-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

// BORDER RADIOUS
$this->add_responsive_control(
    'border_radius',
    [
        'label'      => __( 'Border Radius', 'choicy-core' ),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors'  => [
            '{{WRAPPER}} .chy-services-1-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .chy-services-1-item::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);


// BOX MIDDLE BORDER COLOR
$this->add_responsive_control(
    'middle_border_color',
    [
        'label'     => __( 'Middle Border Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-services-1-item .header' => 'border-color: {{VALUE}};',
        ],
    ]
);

// HOVER BOX BORDER COLOR
$this->add_responsive_control(
    'hover_border_color',
    [
        'label'     => __( 'Hover Border Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .chy-services-1-item:hover .header' => 'border-color: {{VALUE}};',
        ],
    ]
);


// END
$this->end_controls_section();