<?php
namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_Image_Box extends Element_El_Widget {

    /**
     * Slider Style Dependency
     *
     * @return void
     */
    public function get_style_depends() {
        return [ 'img-box-8' ];
    }

    /**
     * Get widget name.
     *
     * Retrieve Choicy Core widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'tx_image_box';
    }

    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'TX Image Box', 'choicy-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/icon-box/';
    }

    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-preview-medium';
    }

    public function get_keywords() {
        return ['service', 'gird', 'icon'];
    }

    protected function register_content_controls() {

        $this->start_controls_section(
            '_section_design_title',
            [
                'label' => __( 'Design Style', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'choicy-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'choicy-core' ),
                    'style_2' => __( 'Style 2', 'choicy-core' ),
                    'style_3' => __( 'Style 3', 'choicy-core' ),
                    'style_4' => __( 'Style 4', 'choicy-core' ),
                    'style_5' => __( 'Style 5', 'choicy-core' ),
                    'style_6' => __( 'Style 6', 'choicy-core' ),
                    'style_7' => __( 'Style 7', 'choicy-core' ),
                    'style_8' => __( 'Style 8', 'choicy-core' ),
                    'style_9' => __( 'Style 9', 'choicy-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        // IMAEG BOX
        $this->start_controls_section(
            '_section_image_box',
            [
                'label' => __( 'Image Box', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // image
        $this->add_control(
            'image_1',
            [
                'label'              => __( 'Image', 'choicy-core' ),
                'type'               => Controls_Manager::MEDIA,
                'default'            => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        // image 2
        $this->add_control(
            'image_2',
            [
                'label'              => __( 'Image 2', 'choicy-core' ),
                'type'               => Controls_Manager::MEDIA,
                'default'            => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'frontend_available' => true,
                'style_transfer'     => true,
                'condition'          => [
                    'design_style' => ['style_2', 'style_3', 'style_4', 'style_9'],
                ],
            ]
        );

        // image 3
        $this->add_control(
            'image_3',
            [
                'label'              => __( 'Image 3', 'choicy-core' ),
                'type'               => Controls_Manager::MEDIA,
                'default'            => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'frontend_available' => true,
                'style_transfer'     => true,
                'condition'          => [
                    'design_style' => 'style_2',
                ],
            ]
        );

        // image 4
        $this->add_control(
            'image_4',
            [
                'label'              => __( 'Image 4', 'choicy-core' ),
                'type'               => Controls_Manager::MEDIA,
                'default'            => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'frontend_available' => true,
                'style_transfer'     => true,
                'condition'          => [
                    'design_style' => 'style_2',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_section_feature_lists',
            [
                'label' => __( 'Feature Lists', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'conition' => [
                    'enable_feature_lists' => 'yes',
                    'design_style' => 'style_1',
                ],
            ]
        );

        // heading title
        $this->add_control(
            'heading_title',
            [
                'label'       => __( 'Heading Title', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( 'Heading Title', 'choicy-core' ),
                'placeholder' => __( 'Enter your heading title', 'choicy-core' ),
            ]
        );

        // repeatable
        $repeater = new \Elementor\Repeater();

        // is_active
        $repeater->add_control(
            'is_active',
            [
                'label'              => __( 'Active', 'choicy-core' ),
                'type'               => Controls_Manager::SWITCHER,
                'default'            => 'no',
                'frontend_available' => true,
                'style_transfer'     => true,
                'label_on'           => __( 'Yes', 'choicy-core' ),
                'label_off'          => __( 'No', 'choicy-core'),
            ]
        );

        // icon
        $repeater->add_control(
            'feature_icon',
            [
                'label'       => __( 'Icon', 'choicy-core' ),
                'type'        => Controls_Manager::ICONS,
                'label_block' => true,
                'default'     => [
                    'value'   => 'fas fa-check',
                    'library' => 'fa-solid',
                ],
            ]
        );

        // counter number
        $repeater->add_control(
            'counter_number',
            [
                'label'       => __( 'Counter Number', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( '64', 'choicy-core' ),
                'placeholder' => __( 'Enter your counter number', 'choicy-core' ),
            ]
        );

        // prefix
        $repeater->add_control(
            'counter_prefix',
            [
                'label'       => __( 'Counter Prefix', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( '%', 'choicy-core' ),
                'placeholder' => __( 'Enter your counter prefix', 'choicy-core' ),
            ]
        );

        // feature title
        $repeater->add_control(
            'feature_title',
            [
                'label'       => __( 'Feature Title', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __( 'Feature Title', 'choicy-core' ),
                'placeholder' => __( 'Enter your feature title', 'choicy-core' ),
            ]
        );

        // end repeatable
        $this->add_control(
            'feature_lists',
            [
                'label'       => __( 'Feature Lists', 'choicy-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'feature_title' => __( 'Title #1', 'choicy-core' ),
                    ],
                ],
                'title_field' => '{{{ feature_title }}}',
            ]
        );

        $this->end_controls_section();

        // settings
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'Settings', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'conition' => [
                    'design_style' => 'style_1',
                ],
            ]
        );

        // FEATURE LIST ENABLE
        $this->add_control(
            'enable_feature_lists',
            [
                'label'              => __( 'Enable Feature Lists', 'choicy-core' ),
                'type'               => Controls_Manager::SWITCHER,
                'default'            => 'yes',
                'frontend_available' => true,
                'style_transfer'     => true,
                'label_on'           => __( 'Yes', 'choicy-core' ),
                'label_off'          => __( 'No', 'choicy-core'),
            ]
        );

        // END
        $this->end_controls_section();

    }

    protected function register_style_controls() {

    }

    /**
     * Render widget output on the frontend.
     *
     * Used to generate the final HTML displayed on the frontend.
     *
     * Note that if skin is selected, it will be rendered by the skin itself,
     * not the widget.
     *
     * @since 1.0.0
     * @access public
     */
    protected function render() {

        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $style = !empty($settings['design_style']) ? $settings['design_style'] : 'style_1';

        switch ($style) {
            case 'style_9':
                include $dir . '/views/view-9.php';
                break;

            case 'style_8':
                include $dir . '/views/view-8.php';
                break;

            case 'style_7':
                include $dir . '/views/view-7.php';
                break;
            case 'style_6':
                include $dir . '/views/view-6.php';
                break;
            case 'style_5':
                include $dir . '/views/view-5.php';
                break;
            case 'style_4':
                include $dir . '/views/view-4.php';
                break;
            case 'style_3':
                include $dir . '/views/view-3.php';
                break;
            case 'style_2':
                include $dir . '/views/view-2.php';
                break;
            default:
                include $dir . '/views/view-1.php';
        }
    }

}