<div class="chy-hero-2-area fix" data-background="<?php echo $settings['bg_image']['url'] ? esc_url($settings['bg_image']['url']) : ''; ?>">
    <div class="container chy-container-1">
        <div class="chy-hero-2-wrap">
            <div class="chy-hero-2-slider">
                <div class="swiper-container chy_hero_2_active">
                    <div class="swiper-wrapper">
                        <?php foreach ( $settings['slides'] as $slide ) : ?>
                        <div class="swiper-slide">
                            <div class="chy-hero-2-item">
                                <div class="chy-hero-2-item-img">
                                    <div class="main-img">
                                        <?php if(!empty( $slide['slide_image']['url'] )) : ?>
                                        <img class="person-img" src="<?php echo esc_url($slide['slide_image']['url']); ?>" alt="">
                                        <?php endif; ?>

                                        <?php if(!empty( $settings['shape_image_1']['url'] )) : ?>
                                        <img class="il-frame" src="<?php echo esc_url($settings['shape_image_1']['url']); ?>" alt="">
                                        <?php endif; ?>
                                    </div>

                                    <?php if(!empty( $settings['shape_image_2']['url'] )) : ?>
                                    <img src="<?php echo esc_url($settings['shape_image_2']['url']); ?>" class="il-img-1" alt="">
                                    <?php endif; ?>

                                    <?php if(!empty( $settings['shape_image_3']['url'] )) : ?>
                                    <img src="<?php echo esc_url($settings['shape_image_3']['url']); ?>" class="il-img-2" alt="">
                                    <?php endif; ?>

                                    <?php if(!empty( $settings['shape_image_4']['url'] )) : ?>
                                    <img src="<?php echo esc_url($settings['shape_image_4']['url']); ?>" class="il-img-3" alt="">
                                    <?php endif; ?>
                                </div>
                                <div class="chy-hero-2-item-content">
                                    <?php if(!empty( $slide['sub_title'] )) : ?>
                                    <h3 class="chy-heading-1 hero-2-subtitle">
                                        <?php echo elh_element_kses_intermediate( $slide['sub_title'] ); ?>
                                    </h3>
                                    <?php endif; ?>
                                    <?php
                                        $this->add_render_attribute( 'title', 'class', 'tx-title chy-heading-1 hero-2-title' );
                                        $title = elh_element_kses_intermediate( $slide['title'] );
                                        printf('<%1$s %2$s>%3$s</%1$s>',
                                            tag_escape($slide['title_tag']),
                                            $this->get_render_attribute_string('title'),
                                            $title
                                        );
                                        $this->add_render_attribute( 'title_2', 'class', 'tx-title chy-heading-1 hero-2-title-2' );
                                        $title_2 = elh_element_kses_intermediate( $slide['title_2'] );
                                        printf('<%1$s %2$s>%3$s</%1$s>',
                                            tag_escape($slide['title_tag']),
                                            $this->get_render_attribute_string('title_2'),
                                            $title_2
                                        );
                                    ?>
                                    <?php if(!empty( $slide['description'] )) : ?>
                                    <p class="chy-para-1 hero-2-disc">
                                        <?php echo elh_element_kses_intermediate( $slide['description'] ); ?>
                                    </p>
                                    <?php endif; ?>

                                    <?php if(!empty( $slide['button_text'] )) : ?>
                                    <a class="chy-pr-btn-3" href="<?php echo esc_url($slide['button_link']['url']); ?>">
                                        <span class="text"><?php echo elh_element_kses_intermediate( $slide['button_text'] ); ?></span>
                                        <?php
                                             \Elementor\Icons_Manager::render_icon( $slide['button_icon'], [ 'aria-hidden' => 'true' ] );
                                        ?>
                                    </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <?php if( $settings['enable_slider_navigation'] === 'yes' ) : ?>
                <div class="chy-hero-2-btn">
                    <div class="chy_hero_2_prev">
                        <i class="far fa-long-arrow-left"></i>
                    </div>
                    <div class="chy_hero_2_next">
                        <i class="far fa-long-arrow-right"></i>
                    </div>
                </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div>
<!-- hero-end -->