<?php

namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_Hero_Slider extends Element_El_Widget {

    /**
     * Get widget name.
     *
     * Retrieve Element Helper widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'tx_hero_slider';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return __( 'TX Hero Slide', 'choicy-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/gradient-heading/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-t-letter';
    }

    public function get_keywords() {
        return ['choicy', 'slide'];
    }

    protected function register_content_controls() {

        //Settings
        $this->start_controls_section(
            '_section_design_settings',
            [
                'label' => __( 'Choos Design', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'choicy-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'choicy-core' ),
                    'style_2' => __( 'Style 2', 'choicy-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        // SHAPE IMAGES
        $this->start_controls_section(
            '_section_shape_images',
            [
                'label' => __( 'Shape Images', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'style_1',
                ],
            ]
        );

        // bg image
        $this->add_control(
            'bg_image',
            [
                'label'   => __( 'BG Image', 'choicy-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // SHAPE IMAGE 1
        $this->add_control(
            'shape_image_1',
            [
                'label'   => __( 'Shape Image 1', 'choicy-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // SHAPE IMAGE 2
        $this->add_control(
            'shape_image_2',
            [
                'label'   => __( 'Shape Image 2', 'choicy-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // SHAPE IMAGE 3
        $this->add_control(
            'shape_image_3',
            [
                'label'   => __( 'Shape Image 3', 'choicy-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // SHAPE IMAGE 4
        $this->add_control(
            'shape_image_4',
            [
                'label'   => __( 'Shape Image 4', 'choicy-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // END
        $this->end_controls_section();

        // SLIDE ITEMS
        $this->start_controls_section(
            '_section_slide_items',
            [
                'label' => __( 'Slide Items', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        // design style
        $repeater->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'choicy-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'choicy-core' ),
                    'style_2' => __( 'Style 2', 'choicy-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        // SLIDE IMAGE
        $repeater->add_control(
            'slide_image',
            [
                'label'   => __( 'Slide Image', 'choicy-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // shape image 1
        $repeater->add_control(
            'shape_image_1',
            [
                'label'   => __( 'Shape Image 1', 'choicy-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'design_style' => 'style_2',
                ],
            ]
        );

        // shape image 2
        $repeater->add_control(
            'shape_image_2',
            [
                'label'   => __( 'Shape Image 2', 'choicy-core' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'design_style' => 'style_2',
                ],
            ]
        );

        // sub title
        $repeater->add_control(
            'sub_title',
            [
                'label'       => __( 'Sub Title', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your sub title', 'choicy-core' ),
                'default'     => __( 'We are the best', 'choicy-core' ),
            ]
        );

        // title
        $repeater->add_control(
            'title',
            [
                'label'       => __( 'Title', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'choicy-core' ),
                'default'     => __( 'We are the best', 'choicy-core' ),
            ]
        );

        // title 2
        $repeater->add_control(
            'title_2',
            [
                'label'       => __( 'Title 2', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title 2', 'choicy-core' ),
                'default'     => __( 'We are the best', 'choicy-core' ),
            ]
        );

        // tag
        $repeater->add_control(
            'title_tag',
            [
                'label'     => __( 'Title HTML Tag', 'choicy-core' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'h1' => [
                        'title' => __( 'H1', 'choicy-core' ),
                        'icon'  => 'eicon-editor-h1',
                    ],
                    'h2' => [
                        'title' => __( 'H2', 'choicy-core' ),
                        'icon'  => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => __( 'H3', 'choicy-core' ),
                        'icon'  => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => __( 'H4', 'choicy-core' ),
                        'icon'  => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => __( 'H5', 'choicy-core' ),
                        'icon'  => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => __( 'H6', 'choicy-core' ),
                        'icon'  => 'eicon-editor-h6',
                    ],
                ],
                'default'   => 'h2',
                'toggle'    => false,
            ]
        );

        // description
        $repeater->add_control(
            'description',
            [
                'label'       => __( 'Description', 'choicy-core' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your description', 'choicy-core' ),
                'default'     => __( 'We are the best', 'choicy-core' ),
                'condition'   => [
                    'design_style' => 'style_1',
                ],
            ]
        );

        // button text
        $repeater->add_control(
            'button_text',
            [
                'label'       => __( 'Button Text', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your button text', 'choicy-core' ),
                'default'     => __( 'Get Started', 'choicy-core' ),
            ]
        );

        // button link
        $repeater->add_control(
            'button_link',
            [
                'label'       => __( 'Button Link', 'choicy-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'Enter your button link', 'choicy-core' ),
                'default'     => [
                    'url' => '#',
                ],
            ]
        );

        // button icon
        $repeater->add_control(
            'button_icon',
            [
                'label'       => __( 'Button Icon', 'choicy-core' ),
                'type'        => Controls_Manager::ICONS,
                'placeholder' => __( 'Enter your button icon', 'choicy-core' ),
                'default'     => [
                    'value'   => 'fas fa-long-arrow-right',
                    'library' => 'fa-solid',
                ],
                'condition'   => [
                    'design_style' => 'style_1',
                ],
            ]
        );

        $this->add_control(
            'slides',
            [
                'label'       => __( 'Slides', 'choicy-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();

        // SETTINGS
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'Settings', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // ENABLE SLIDER NAVIGATION
        $this->add_control(
            'enable_slider_navigation',
            [
                'label'        => __( 'Enable Slider Navigation', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // END
        $this->end_controls_section();

    }

    protected function register_style_controls() {


    }

    protected function render() {

        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $style = !empty($settings['design_style']) ? $settings['design_style'] : 'style_1';

        switch ($style) {
            case 'style_2':
                include $dir . '/views/view-2.php';
                break;
            default:
                include $dir . '/views/view-1.php';
        }
    }
}
