<div class="chy-hero-4-area fix">
    <div class="chy-hero-4-wrap">
        <?php if(!empty( $settings['image_1']['url'] )) : ?>
            <div class="bg-img">
                <img src="<?php echo esc_url($settings['image_1']['url']); ?>" alt="">
            </div>
        <?php endif; ?>
        <div class="container chy-container">
            <div class="chy-hero-4-content-wrap">
                <div class="row align-items-end">

                    <!-- left-content -->
                    <div class="col-xxl-6 col-xl-7 col-lg-7">
                        <div class="chy-hero-4-content">
                            <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
                            <h4 class="chy-subtitle-4 chy-class-add tx-subTitle">
                                <?php echo elh_element_kses_intermediate($settings['sub_title']); ?>
                            </h4>
                            <?php endif;?>
                            <?php
                                if($settings['title_enable_gradient'] === 'yes') {
                                    $has_gd = 'has-gd';
                                } else {
                                    $has_gd = '';
                                }
                                $title = elh_element_kses_basic( $settings['title'] );
                                $this->add_render_attribute( 'title', 'class', 'tx-title hero-title chy-heading-2 chy-split-text-4 chy-split-in-hero-4 '.esc_attr($has_gd).'' );
                                if($settings['enable_title'] === 'yes') {
                                    printf('<%1$s %2$s>%3$s</%1$s>',
                                        tag_escape($settings['title_tag']),
                                        $this->get_render_attribute_string('title'),
                                        $title
                                    );
                                }
                            ?>
                            <?php if( $settings['enable_description'] === 'yes' ) : ?>
                                <p class="chy-para-4 has-20 disc wow fadeInUp tx-description" data-wow-duration="2s" data-wow-delay="1s" ><?php echo elh_element_kses_intermediate($settings['description']); ?></p>
                            <?php endif; ?>
                            <div class="btn-wrap wow fadeInUp" data-wow-duration="2s" data-wow-delay="1.5s">
                            <?php if( $settings['enable_button'] === 'yes' ) : ?>
                                <a
                                href="<?php echo esc_url($settings['button_link']['url']); ?>"
                                aria-label="hero btn"
                                class="chy-pr-btn-5 tx-button"
                                target="<?php echo esc_attr( $settings['button_link']['is_external'] ? '_blank' : '_self' ); ?>"
                                rel="<?php echo esc_attr( $settings['button_link']['nofollow'] ? 'nofollow' : '' ); ?>"
                                >
                                    <span class="text">
                                        <?php echo elh_element_kses_intermediate($settings['button_text']); ?>
                                    </span>
                                    <?php if( $settings['enable_button_icon'] === 'yes' ) : ?>
                                        <span class="icon">
                                            <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </span>
                                    <?php endif; ?>
                                </a>
                                <?php endif; ?>
                                <?php if( $settings['enable_video_button'] === 'yes' ) : ?>
                                <a class="chy-plybtn-3 popup-video"  href="<?php echo esc_url($settings['video_button_link']['url']); ?>">
                                    <span class="icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="61" height="60" viewBox="0 0 61 60" fill="none">
                                            <g clip-path="url(#clip0_66_147)">
                                            <path class="path-1" d="M40.8682 28.8271L28.4094 19.7705C27.9522 19.439 27.3452 19.3891 26.844 19.6467C26.3389 19.9022 26.0234 20.4214 26.0234 20.9824V39.0896C26.0234 39.6567 26.3389 40.1738 26.844 40.4294C27.0577 40.5372 27.2913 40.5911 27.5269 40.5911C27.8344 40.5911 28.1458 40.4932 28.4094 40.2996L40.8682 31.251C41.2615 30.9614 41.4911 30.5142 41.4911 30.039C41.4931 29.5558 41.2575 29.1106 40.8682 28.8271Z" fill="#36C4F7"/>
                                            <path class="path-2" d="M30.9737 0.00390625C14.4018 0.00390625 0.972656 13.4331 0.972656 30.0049C0.972656 46.5707 14.4018 59.9959 30.9737 59.9959C47.5415 59.9959 60.9727 46.5687 60.9727 30.0049C60.9747 13.4331 47.5415 0.00390625 30.9737 0.00390625ZM30.9737 54.9904C17.1731 54.9904 5.98414 43.8074 5.98414 30.0049C5.98414 16.2084 17.1731 5.01139 30.9737 5.01139C44.7722 5.01139 55.9592 16.2064 55.9592 30.0049C55.9612 43.8074 44.7722 54.9904 30.9737 54.9904Z" fill="#36C4F7"/>
                                            </g>
                                            <defs>
                                            <clipPath id="clip0_66_147">
                                            <rect width="60" height="60" fill="white" transform="translate(0.972656)"/>
                                            </clipPath>
                                            </defs>
                                            </svg>
                                    </span>
                                    <span class="text chy-para-1"><?php echo elh_element_kses_intermediate($settings['video_button_text']); ?></span>
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- right-content -->
                    <div class="col-xxl-6 col-xl-5 col-lg-5">
                        <div class="chy-hero-img chy-class-add ">
                        <?php if(!empty( $settings['image_2']['url'] )) : ?>
                            <div class="main-img">
                                <img src="<?php echo esc_url($settings['image_2']['url']); ?>" alt="">
                            </div>
                            <?php endif; ?>
                            <?php if(!empty( $settings['image_3']['url'] )) : ?>
                            <div class="il-img-1">
                                <img src="<?php echo esc_url($settings['image_3']['url']); ?>" alt="" class="object" data-value="3">
                            </div>
                            <?php endif; ?>
                            <?php if(!empty( $settings['image_4']['url'] )) : ?>
                            <div class="il-img-2">
                                <img src="<?php echo esc_url($settings['image_4']['url']); ?>" alt="" class="object" data-value="7">
                            </div>
                            <?php endif; ?>
                            <?php if(!empty( $settings['image_5']['url'] )) : ?>
                            <div class="il-img-3">
                                <img src="<?php echo esc_url($settings['image_5']['url']); ?>" alt="" class="object" data-value="5" >
                            </div>
                            <?php endif; ?>


                        </div>
                    </div>
                </div>
            </div>

        </div>
        <?php if($settings['enable_social_info'] === 'yes'):?>
            <ul class="chy-hero-4-social tx-socialLists">
                <?php if(!empty($settings['social_title'])):?>
                    <li class="text"><?php echo wp_kses($settings['social_title'], true);?></span>
                <?php endif;?>
                <?php foreach($settings['socials'] as $item):?>
                <li>
                    <a aria-label="social link" href="<?php echo esc_url($item['link']['url']);?>"
                    target="<?php echo esc_attr( $item['link']['is_external'] ? '_blank' : '_self' ); ?>"
                    rel="<?php echo esc_attr( $item['link']['nofollow'] ? 'nofollow' : '' ); ?>">
                        <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    </a>
                </li>
                <?php endforeach;?>
            </ul>
        <?php endif;?>
        <?php if($settings['enable_scroll_down'] === 'yes'):?>
            <div class="chy-hero-4-scroll-btn-wrap">
                <span class="text"><?php echo esc_html($settings['scroll_title']);?></span>
                <a href="<?php echo esc_url($settings['scroll_link']['url']);?>" aria-label="down button" class="icon">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['scroll_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </a>
            </div>
        <?php endif;?>

    </div>
</div>