<?php
namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_Hero_Section extends Element_El_Widget {
    /**
     * Slider Style Dependency
     *
     * @return void
     */
    public function get_style_depends() {
        return [ 'hero-2' ];
    }
    /**
     * Get widget name.
     *
     * Retrieve Choicy Core widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'tx_hero_section';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return __( 'TX Hero Section', 'choicy-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/gradient-heading/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-t-letter';
    }

    public function get_keywords() {
        return ['section', 'heading', 'title'];
    }

    protected function register_content_controls() {

        //Settings
        $this->start_controls_section(
            '_section_style_settings',
            [
                'label' => __( 'CHOOSE STYLE', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'choicy-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Style 1', 'choicy-core' ),
                    'style_2' => __( 'Style 2', 'choicy-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        // IMAGE SECTION
        $this->start_controls_section(
            '_section_image',
            [
                'label' => __( 'Image', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // BG_IMAGE
        $this->add_control(
            'bg_image',
            [
                'label'       => __( 'Background Image', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic'     => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => [ 'style_1' ],
                ],
            ]
        );

        // IMAGE 1
        $this->add_control(
            'image_1',
            [
                'label'       => __( 'Image 1', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // IMAGE 2
        $this->add_control(
            'image_2',
            [
                'label'       => __( 'Image 2', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // IMAGE 3
        $this->add_control(
            'image_3',
            [
                'label'       => __( 'Image 3', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // IMAGE 4
        $this->add_control(
            'image_4',
            [
                'label'       => __( 'Image 4', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // IMAGE 5
        $this->add_control(
            'image_5',
            [
                'label'       => __( 'Image 5', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // image 6
        $this->add_control(
            'image_6',
            [
                'label'       => __( 'Image 6', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic'     => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => [ 'style_1' ],
                ],
            ]
        );

        // END
        $this->end_controls_section();

        $this->start_controls_section(
            '_section_title',
            [
                'label' => __( 'Title & Description', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // sub title
        $this->add_control(
            'sub_title',
            [
                'label'       => __( 'Sub Title', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => 'Sub Title',
                'placeholder' => __( 'Sub Title Text', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'enable_sub_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => 'Heading Title',
                'placeholder' => __( 'Heading Text', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'enable_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'     => __( 'Title HTML Tag', 'choicy-core' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'h1' => [
                        'title' => __( 'H1', 'choicy-core' ),
                        'icon'  => 'eicon-editor-h1',
                    ],
                    'h2' => [
                        'title' => __( 'H2', 'choicy-core' ),
                        'icon'  => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => __( 'H3', 'choicy-core' ),
                        'icon'  => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => __( 'H4', 'choicy-core' ),
                        'icon'  => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => __( 'H5', 'choicy-core' ),
                        'icon'  => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => __( 'H6', 'choicy-core' ),
                        'icon'  => 'eicon-editor-h6',
                    ],
                ],
                'default'   => 'h2',
                'toggle'    => false,
                'condition' => [
                    'enable_title' => 'yes',
                ],
            ]
        );

        // description
        $this->add_control(
            'description',
            [
                'label'       => __( 'Description', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => 'Description Text',
                'placeholder' => __( 'Description Text', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'enable_description' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // BUTTON
        $this->start_controls_section(
            '_section_button',
            [
                'label' => __( 'Button', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // BUTTON TEXT
        $this->add_control(
            'button_text',
            [
                'label'       => __( 'Button Text', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Button Text', 'choicy-core' ),
                'placeholder' => __( 'Button Text', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // BUTTON LINK
        $this->add_control(
            'button_link',
            [
                'label'       => __( 'Button Link', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // ENABLE BUTTON ICON
        $this->add_control(
            'enable_button_icon',
            [
                'label'        => __( 'Enable Button Icon', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // BUTTON ICON
        $this->add_control(
            'button_icon',
            [
                'label'       => __( 'Button Icon', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fas fa-angle-right',
                    'library' => 'fa-solid',
                ],
                'condition'   => [
                    'enable_button_icon' => 'yes',
                ],
            ]
        );

        // END
        $this->end_controls_section();

        // VIDEO BUTTON
        $this->start_controls_section(
            '_section_video_button',
            [
                'label' => __( 'Video Button', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'enable_video_button' => 'yes',
                ],
            ]
        );

        // VIDEO BUTTON TEXT
        $this->add_control(
            'video_button_text',
            [
                'label'       => __( 'Video Button Text', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Video Button Text', 'choicy-core' ),
                'placeholder' => __( 'Video Button Text', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // VIDEO BUTTON LINK
        $this->add_control(
            'video_button_link',
            [
                'label'       => __( 'Video Button Link', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
            ]
        );

        // VIDEO BUTTON ICON
        $this->add_control(
            'video_button_icon',
            [
                'label'       => __( 'Video Button Icon', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fas fa-play',
                    'library' => 'fa-solid',
                ],
            ]
        );

        // END
        $this->end_controls_section();

        $this->start_controls_section(
            '_section_social',
            [
                'label' => __( 'Social Icon', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition'   => [
                    'enable_social_info' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'social_title',
            [
                'label'       => __( 'Social Title', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXTAREA,
                'rows'        => 4,
                'default'     => 'SOCIAL MEDIA',
                'placeholder' => __( 'Social Title Text', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'enable_social_info' => 'yes',
                ],
            ]
        );
        $repeater = new \Elementor\Repeater();


        // faq title
        $repeater->add_control(
            'icon',
            [
                'label'       => __( 'Icon', 'choicy-core' ),
                'type'        => Controls_Manager::ICONS,
                'label_block' => true,
            ]
        );

        // faq content
        $repeater->add_control(
            'link',
            [
                'label'       => __( 'Social Link', 'choicy-core' ),
                'type'        => Controls_Manager::URL,
                'label_block' => true,
            ]
        );

        // faq lists
        $this->add_control(
            'socials',
            [
                'label'       => __( 'Lists', 'choicy-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'condition'   => [
                    'enable_social_info' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            '_section_scroll_dw',
            [
                'label' => __( 'Scroll Down', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition'   => [
                    'enable_scroll_down' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'scroll_title',
            [
                'label'       => __( 'Scroll Down Title', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'rows'        => 4,
                'default'     => 'scroll down',
                'placeholder' => __( 'Scroll down Title Text', 'choicy-core' ),
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'enable_scroll_down' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'scroll_icon',
            [
                'label'       => __( 'Scroll Down Icon', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::ICONS,
                'condition'   => [
                    'enable_scroll_down' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'scroll_link',
            [
                'label'       => __( 'Scroll Down Link', 'choicy-core' ),
                'label_block' => true,
                'type'        => Controls_Manager::URL,
                'condition'   => [
                    'enable_scroll_down' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
        // SETTINGS
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'Settings', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // ENABLE SUB TITLE
        $this->add_control(
            'enable_sub_title',
            [
                'label'        => __( 'Enable Sub Title', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // ENABLE TITLE
        $this->add_control(
            'enable_title',
            [
                'label'        => __( 'Enable Title', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // ENABLE DESCRIPTION
        $this->add_control(
            'enable_description',
            [
                'label'        => __( 'Enable Description', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // ENABLE BUTTON
        $this->add_control(
            'enable_button',
            [
                'label'        => __( 'Enable Button', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // ENABLE VIDEO BUTTON
        $this->add_control(
            'enable_video_button',
            [
                'label'        => __( 'Enable Video Button', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );
        $this->add_control(
            'enable_social_info',
            [
                'label'        => __( 'Enable Social Icon', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );
        $this->add_control(
            'enable_scroll_down',
            [
                'label'        => __( 'Enable Scroll Down', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'choicy-core' ),
                'label_off'    => __( 'Hide', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        $this->end_controls_section();

    }

    protected function register_style_controls() {
        $dir = dirname( __FILE__ );

        $style_files = glob( $dir . '/styles/*.php' );

        if ( $style_files ) {
            foreach ( $style_files as $style_file ) {
                include $style_file;
            }
        }

    }

    protected function render() {

        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $this->add_inline_editing_attributes( 'title', 'basic' );
        $title = elh_element_kses_basic( $settings['title'] );

        if ( !empty( $settings['design_style'] ) && $settings['design_style'] == 'style_3' ):
            include $dir . '/views/view-3.php';

        elseif ( !empty( $settings['design_style'] ) && $settings['design_style'] == 'style_2' ):
            include $dir . '/views/view-2.php';
        else:
            include $dir . '/views/view-1.php';
        endif;
    }
}
