<?php
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;

$this->start_controls_section(
    '_section_style_sub_title',
    [
        'label' => __( 'SUB HEADING STYLE', 'choicy-core' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

// sub title color
$this->add_control(
    'sub_title_color',
    [
        'label'     => __( 'Sub Title Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .tx-subTitle' => 'color: {{VALUE}};',
        ],
    ]
);

// sub title bg color
$this->add_control(
    'sub_title_bg_color',
    [
        'label'     => __( 'Background Color', 'choicy-core' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .tx-subTitle' => 'background-color: {{VALUE}};',
        ],
    ]
);

// bg control field
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'sub_title_bg_gradient',
        'label'    => __( 'Gradient Background', 'choicy-core' ),
        'types'    => ['gradient'],
        'exclude'  => ['image', 'video'],
        'selector' => '
                    {{WRAPPER}} .tx-subTitle,
                    {{WRAPPER}} .chy-subtitle-4::after
                ',
    ]
);

// sub title padding
$this->add_responsive_control(
    'sub_title_padding',
    [
        'label'      => __( 'Padding', 'choicy-core' ),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors'  => [
            '{{WRAPPER}} .tx-subTitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

// sub title margin
$this->add_responsive_control(
    'sub_title_margin',
    [
        'label'      => __( 'Margin', 'choicy-core' ),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', 'em', '%'],
        'selectors'  => [
            '{{WRAPPER}} .tx-subTitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

// sub title typography
$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'     => 'sub_title_typography',
        'label'    => __( 'Typography', 'choicy-core' ),
        'selector' => '
                {{WRAPPER}} .tx-subTitle
                ',
    ]
);

// sub title border radius
$this->add_responsive_control(
    'sub_title_border_radius',
    [
        'label'      => __( 'Border Radius', 'choicy-core' ),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors'  => [
            '{{WRAPPER}} .tx-subTitle' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->end_controls_section();