<?php
    if($settings['align'] === 'center') {
        $align = 'text-center';
    } elseif($settings['align'] === 'right') {
        $align = 'text-right';
    } else {
        $align = 'text-left';
    }

    $subtitle_animation = '';
    if( $settings['enable_sub_title'] === 'yes' ) {
        if($settings['enable_sub_title_anim'] === 'yes') {
            $subtitle_animation = 'wow '.$settings['sub_title_animation'];
        } else {
            $subtitle_animation = '';
        }
    } else {
        $subtitle_animation = '';
    }

    $title_animation = '';
    if( $settings['enable_title'] === 'yes' ) {
        if($settings['enable_title_anim'] === 'yes') {
            $title_animation = 'chy-split-text '.$settings['title_animation'];
        } else {
            $title_animation = '';
        }
    } else {
        $title_animation = '';
    }

    $description_animation = '';
    if( $settings['enable_description'] === 'yes' ) {
        if($settings['enable_description_anim'] === 'yes') {
            $description_animation = 'wow '.$settings['description_animation'];
        } else {
            $description_animation = '';
        }
    } else {
        $description_animation = '';
    }

    if($settings['enable_sub_title'] === 'yes' && $settings['enable_sub_title_shape'] === 'yes' ) {
        $sub_title_shape = ' isShape';
    } else {
        $sub_title_shape = ' noShape';

    }

?>
<div class="section-title-wrap <?php echo esc_attr($align); ?>">
    <?php if( $settings['enable_sub_title'] === 'yes' ) : ?>
    <h5 class="chy-subtitle-1 tx-subTitle <?php echo esc_attr($subtitle_animation . $sub_title_shape); ?>">
        <?php echo elh_element_kses_intermediate($settings['sub_title']); ?>
    </h5>
    <?php endif; ?>

    <?php
        $this->add_render_attribute( 'title', 'class', 'tx-title chy-title-1 '.esc_attr($title_animation).'' );
        if($settings['enable_title'] === 'yes') {
            printf('<%1$s %2$s>%3$s</%1$s>',
                tag_escape($settings['title_tag']),
                $this->get_render_attribute_string('title'),
                $title
            );
        }
    ?>

    <?php if($settings['enable_description'] === 'yes') : ?>
    <p class="tx-description chy-para-1 <?php echo esc_attr($description_animation); ?>">
        <?php echo elh_element_kses_intermediate($settings['description']); ?>
    </p>
    <?php endif; ?>
</div>