<?php

    $enable_custom_link = $settings['enable_custom_link'];
    if($enable_custom_link == 'yes') {
        $custom_link = $settings['custom_link']['url'];
    } else {
        $custom_link = home_url( '/' );
    }

    // enable position
    $enable_position_absolute = $settings['enable_position_absolute'];
    if($enable_position_absolute == 'yes') {
        $position_absolute = 'position-absolute';
    } else {
        $position_absolute = '';
    }

    // enable sticky header
    $enable_sticky_header = $settings['enable_sticky_header'];
    if($enable_sticky_header == 'yes') {
        $sticky_header = 'data-txStickyHeader';
    } else {
        $sticky_header = '';
    }

    if($settings['enable_sticky_logo'] === 'yes' ) {
        $sticky_logo = 'has-sticky-logo';
    } else {
        $sticky_logo = '';
    }
?>

<header class="chy-header-2-area transparent-header tx-header <?php echo esc_attr($position_absolute); ?>" <?php echo esc_attr($sticky_header); ?>>
    <div class="chy-header-2-wrap">

        <!-- header-logo -->
        <?php if(!empty( $settings['logo']['url'] )) : ?>
        <a class="d-block chy-logo tx-logo <?php echo esc_attr($sticky_logo); ?>" href="<?php echo esc_url($custom_link); ?>">
            <?php if(!empty( $settings['logo']['url'] )) : ?>
            <img class="tx-defaultLogo" src="<?php echo esc_url($settings['logo']['url']); ?>" alt="<?php if(function_exists('choicy_img_alt_text')) { echo choicy_img_alt_text( $settings['logo']['url'] ); } ?>">
            <?php endif; ?>

            <?php if( $settings['enable_sticky_logo'] === 'yes' ) : ?>
            <img class="tx-stickyLogo" src="<?php echo esc_url($settings['sticky_logo']['url']); ?>" alt="<?php if(function_exists('choicy_img_alt_text')) { echo choicy_img_alt_text( $settings['sticky_logo']['url'] ); } ?>">
            <?php endif; ?>
        </a>
        <?php endif; ?>

        <!-- menu -->
        <div class="chy-main-menu-1 has-menu-2 d-none d-lg-block">
            <nav class="main-navigation clearfix ul-li">
                <?php
                    $menu_args = [
                        'menu'        => '' . $settings['select_menu'] . '',
                        'menu_class'     => 'nav navbar-nav clearfix list-unstyled',
                        'menu_id'        => 'main-nav',
                        'walker'         => class_exists('Tx_Mega_Menu_Walker') ? new Tx_Mega_Menu_Walker : '',
                        'fallback_cb'    => ['Navwalker_Class', 'fallback'],
                        'echo'           => false,
                    ];

                    $menu = wp_nav_menu($menu_args);
                    $menu = str_replace('menu-item-has-children', 'dropdown', $menu);
                    $menu = str_replace('sub-menu', 'dropdown-menu', $menu);

                    echo wp_kses_post($menu);
                ?>
            </nav>
        </div>

        <div class="chy-header-2-action-btn">
            <?php if( $settings['enable_search'] === 'yes' ) : ?>
                <button aria-label="search" class="chy-search-btn-1 d-xl-flex d-none search_btn_toggle">
                <i class="far fa-search"></i>
            </button>
            <?php endif; ?>

            <?php if( $settings['enable_button'] === 'yes' ) : ?>
            <a class="chy-pr-btn-2 d-sm-block d-none tx-button" href="<?php echo esc_url($settings['button_link']['url']) ?>">
                <?php echo elh_element_kses_intermediate( $settings['button_text'] ); ?>
            </a>
            <?php endif; ?>

            <div class="chy-menu-btn-1 d-lg-none" id="menuToggle">
                <i class="fa-light fa-bars icon-1"></i>
                <i class="fa-regular fa-angle-left icon-2"></i>
            </div>
        </div>

    </div>
</header>

<?php if( $settings['enable_search'] === 'yes' ) : ?>
<div class="popup-search-box search_1_popup_active ">
    <div class="container">
        <?php if(!empty( $settings['search_heading'] )) : ?>
        <h4 class="title">
            <?php echo elh_element_kses_intermediate( $settings['search_heading'] ); ?>
        </h4>
        <?php endif; ?>
        <div class="popup-search-box-form">
            <form method="get" action="<?php print esc_url( home_url( '/' ) );?>">
                <div class="popup-search-box-input">
                    <input type="search" name="s" placeholder="<?php print esc_attr__( 'Search..', 'choicy-core' );?>" value="<?php print esc_attr( get_search_query() )?>">
                </div>
                <button type="submit"><i class="fal fa-search"></i></button>
            </form>
            <button class="popup-search-box-close-action-btn search_1_popup_close"><i class="fal fa-times"></i></button>
        </div>
    </div>
</div>
<?php endif; ?>

<div class="fullpage-menu">
    <div class="fullpage-menu-inner">
        <div class="menu-bg">
            <span class="span1"></span>
            <span class="span2"></span>
            <span class="span3"></span>
        </div>


        <div class="fullpage-menu-logo-wrap">
            <?php if( $settings['enable_mobile_logo'] === 'yes' ) : ?>
            <a href="<?php echo esc_url($custom_link); ?>" class="menu-logo d-block tx-logo" aria-label="brand-logo"  >
                <img src="<?php echo esc_url($settings['mobile_logo']['url']); ?>" alt="">
            </a>
            <?php endif; ?>
            <i id="menuToggle2" class="far fullpage-menu-close fa-times"></i>
        </div>

        <?php if( $settings['enable_search'] === 'yes' ) : ?>
        <div class="mobile-search-bar">
            <form method="get" action="<?php print esc_url( home_url( '/' ) );?>">
                <input type="search" name="s" placeholder="<?php print esc_attr__( 'Keywords', 'choicy-core' );?>" value="<?php print esc_attr( get_search_query() )?>">
                <button type="button" aria-label="search"><i class="fal fa-search"></i></button>
            </form>
        </div>
        <?php endif; ?>


        <div class="fullpage-content-wrap">

            <!-- mobile-menu-list -->
            <nav class="mobile-main-navigation clearfix ul-li">
                <?php
                    $menu_args = [
                        'menu'        => '' . $settings['select_mobile_menu'] . '',
                        'menu_class'     => 'nav navbar-nav clearfix list-unstyled',
                        'menu_id'        => 'm-main-nav',
                        'walker'         => class_exists('Tx_Mega_Menu_Walker') ? new Tx_Mega_Menu_Walker : '',
                        'fallback_cb'    => ['Navwalker_Class', 'fallback'],
                        'echo'           => false,
                    ];

                    $menu = wp_nav_menu($menu_args);
                    $menu = str_replace('menu-item-has-children', 'dropdown', $menu);
                    $menu = str_replace('sub-menu', 'dropdown-menu', $menu);

                    echo wp_kses_post($menu);
                ?>
            </nav>

            <?php if( $settings['enable_gallery'] === 'yes' ) : ?>
            <div class="fullpage-menu-gellary">
                <?php foreach ( $settings['gallery_items'] as $key => $brand ) :
                    if (!empty($brand['url'])) {
                        $brand_image = $brand['url'];
                    }

                    // alt
                    if (!empty($brand['alt'])) {
                        $brand_alt = $brand['alt'];
                    } else {
                        $brand_alt = '';
                    }
                ?>
                <a href="<?php echo $brand_image ? esc_url($brand_image) : ''; ?>" aria-label="gallery img" class="item img-cover popup_img">
                    <img src="<?php echo $brand_image ? esc_url($brand_image) : ''; ?>" alt="<?php echo esc_attr($brand_alt); ?>">
                </a>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </div>

        <?php if( $settings['enable_social_links'] === 'yes' ) : ?>
        <ul class="full-page-socail-link text-center pt-50 list-unstyled">
            <?php foreach($settings['social_links'] as $list ) : ?>
            <li>
                <a href="<?php echo esc_url($list['social_link']['url']) ?>"
                target="<?php echo esc_attr( $list['social_link']['is_external'] ? '_blank' : '_self' ); ?>"
                rel="<?php echo esc_attr( $list['social_link']['nofollow'] ? 'nofollow' : '' ); ?>">
                    <?php \Elementor\Icons_Manager::render_icon( $list['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </a>
            </li>
            <?php endforeach; ?>
        </ul>
        <?php endif; ?>

    </div>
</div>