<?php

    $enable_custom_link = $settings['enable_custom_link'];
    if($enable_custom_link == 'yes') {
        $custom_link = $settings['custom_link']['url'];
    } else {
        $custom_link = home_url( '/' );
    }

    // enable position
    $enable_position_absolute = $settings['enable_position_absolute'];
    if($enable_position_absolute == 'yes') {
        $position_absolute = 'position-absolute';
    } else {
        $position_absolute = '';
    }

    // enable sticky header
    $enable_sticky_header = $settings['enable_sticky_header'];
    if($enable_sticky_header == 'yes') {
        $sticky_header = 'data-txStickyHeader';
    } else {
        $sticky_header = '';
    }

    // has-inner-page
    $has_inner_page = $settings['has_inner_page'];
    if($has_inner_page == 'yes') {
        $has_inner_page = 'has-inner-page';
    } else {
        $has_inner_page = '';
    }

    if($settings['enable_sticky_logo'] === 'yes' ) {
        $sticky_logo = 'has-sticky-logo';
    } else {
        $sticky_logo = '';
    }
?>

<header class="chy-header-1-area transparent-header tx-header <?php echo esc_attr($has_inner_page. ' ' . $position_absolute); ?>" <?php echo esc_attr($sticky_header); ?>>
    <div class="container chy-container-1">
        <div class="chy-header-1-wrap">
            <div class="left">

                <?php if ( !empty( $settings['select_menu'] ) ) : ?>
                <div class="chy-menu-btn-1 open_mobile_menu" id="menuToggle">
                    <i class="fa-light fa-bars icon-1"></i>
                    <i class="fa-regular fa-angle-left icon-2"></i>
                </div>

                <!-- menu -->
                <div class="chy-main-menu-1 d-none d-lg-block">
                    <nav class="main-navigation clearfix ul-li">
                        <?php
                            $menu_args = [
                                'menu'        => '' . $settings['select_menu'] . '',
                                'menu_class'     => 'nav navbar-nav clearfix list-unstyled',
                                'menu_id'        => 'main-nav',
                                'walker'         => class_exists('Tx_Mega_Menu_Walker') ? new Tx_Mega_Menu_Walker : '',
                                'fallback_cb'    => ['Navwalker_Class', 'fallback'],
                                'echo'           => false,
                            ];

                            $menu = wp_nav_menu($menu_args);
                            $menu = str_replace('menu-item-has-children', 'dropdown', $menu);
                            $menu = str_replace('sub-menu', 'dropdown-menu', $menu);

                            echo wp_kses_post($menu);
                        ?>
                    </nav>
                </div>
                <?php endif; ?>
            </div>

            <?php if(!empty( $settings['logo']['url'] )) : ?>
            <a class="d-block chy-logo tx-logo <?php echo esc_attr($sticky_logo); ?>" href="<?php echo esc_url($custom_link); ?>">
                <img class="tx-defaultLogo" src="<?php echo esc_url($settings['logo']['url']); ?>" alt="<?php if(function_exists('choicy_img_alt_text')) { echo choicy_img_alt_text( $settings['logo']['url'] ); } ?>">

                <?php if( $settings['enable_sticky_logo'] === 'yes' ) : ?>
                <img class="tx-stickyLogo" src="<?php echo esc_url($settings['sticky_logo']['url']); ?>" alt="<?php if(function_exists('choicy_img_alt_text')) { echo choicy_img_alt_text( $settings['sticky_logo']['url'] ); } ?>">
                <?php endif; ?>
            </a>
            <?php endif; ?>

            <!-- search-item -->
            <div class="right d-none d-md-block">
                <div class="chy-cart-1">
                    <?php if( $settings['enable_search'] === 'yes' ) : ?>
                    <form method="get" action="<?php print esc_url( home_url( '/' ) );?>" class="tx-headerSearch">
                        <input type="search" name="s" placeholder="<?php print esc_attr__( 'Search', 'choicy-core' );?>" value="<?php print esc_attr( get_search_query() )?>">
                        <button type="submit" class="search-icon">
                            <i class="fa-solid fa-magnifying-glass"></i>
                        </button>
                    </form>
                    <?php endif; ?>

                    <?php if(CHOICY_CORE_WOOCOMMERCE_ACTIVED && $settings['enable_cart_icon'] === 'yes') : ?>
                    <div class="cart-btn-position">
                        <a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="chy-cart-btn-1">
                            <i class="fa-solid fa-bag-shopping"></i>
                            <span class="tx-cartCount">
                            <?php

                                if (class_exists('WooCommerce') && WC()->cart) {
                                    $count = WC()->cart->cart_contents_count;
                                } else {
                                    $count = 0;
                                }

                                if ( $count == 0 ) {
                                    echo '0';
                                } else {
                                    echo '' . esc_html( $count ) . '';
                                }
                            ?>
                        </span>
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</header>

<div class="fullpage-menu">
    <div class="fullpage-menu-inner">
        <div class="menu-bg">
            <span class="span1"></span>
            <span class="span2"></span>
            <span class="span3"></span>
        </div>


        <div class="fullpage-menu-logo-wrap">
            <?php if( $settings['enable_mobile_logo'] === 'yes' ) : ?>
            <a href="<?php echo esc_url($custom_link); ?>" class="menu-logo d-block" aria-label="brand-logo"  >
                <img src="<?php echo esc_url($settings['mobile_logo']['url']); ?>" alt="<?php if(function_exists('choicy_img_alt_text')) { echo choicy_img_alt_text( $settings['mobile_logo']['url'] ); } ?>">
            </a>
            <?php endif; ?>
            <i id="menuToggle2" class="far fullpage-menu-close fa-times"></i>
        </div>

        <?php if( $settings['enable_search'] === 'yes' ) : ?>
        <div class="mobile-search-bar">
            <form method="get" action="<?php print esc_url( home_url( '/' ) );?>">
                <input type="search" name="s" placeholder="<?php print esc_attr__( 'invite', 'choicy-core' );?>" value="<?php print esc_attr( get_search_query() )?>">
                <button type="button" aria-label="search"><i class="fal fa-search"></i></button>
            </form>
        </div>
        <?php endif; ?>


        <div class="fullpage-content-wrap">

            <!-- mobile-menu-list -->
            <nav class="mobile-main-navigation clearfix ul-li">
                <?php
                    $menu_args = [
                        'menu'        => '' . $settings['select_mobile_menu'] . '',
                        'menu_class'     => 'nav navbar-nav clearfix list-unstyled',
                        'menu_id'        => 'm-main-nav',
                        'walker'         => class_exists('Tx_Mega_Menu_Walker') ? new Tx_Mega_Menu_Walker : '',
                        'fallback_cb'    => ['Navwalker_Class', 'fallback'],
                        'echo'           => false,
                    ];

                    $menu = wp_nav_menu($menu_args);
                    $menu = str_replace('menu-item-has-children', 'dropdown', $menu);
                    $menu = str_replace('sub-menu', 'dropdown-menu', $menu);

                    echo wp_kses_post($menu);
                ?>
            </nav>

            <?php if( $settings['enable_gallery'] === 'yes' ) : ?>
            <div class="fullpage-menu-gellary">
                <?php foreach ( $settings['gallery_items'] as $key => $brand ) :
                    if (!empty($brand['url'])) {
                        $brand_image = $brand['url'];
                    }

                    // alt
                    if (!empty($brand['alt'])) {
                        $brand_alt = $brand['alt'];
                    } else {
                        $brand_alt = '';
                    }
                ?>
                <a href="<?php echo $brand_image ? esc_url($brand_image) : ''; ?>" aria-label="gallery img" class="item img-cover popup_img">
                    <img src="<?php echo $brand_image ? esc_url($brand_image) : ''; ?>" alt="<?php echo esc_attr($brand_alt); ?>">
                </a>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </div>

        <?php if( $settings['enable_social_links'] === 'yes' ) : ?>
        <ul class="full-page-socail-link text-center pt-50 list-unstyled">
            <?php foreach($settings['social_links'] as $list ) : ?>
            <li>
                <a href="<?php echo esc_url($list['social_link']['url']) ?>"
                target="<?php echo esc_attr( $list['social_link']['is_external'] ? '_blank' : '_self' ); ?>"
                rel="<?php echo esc_attr( $list['social_link']['nofollow'] ? 'nofollow' : '' ); ?>">
                    <?php \Elementor\Icons_Manager::render_icon( $list['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                </a>
            </li>
            <?php endforeach; ?>
        </ul>
        <?php endif; ?>

    </div>
</div>