<?php

namespace ElementHelper\Widget;

use \Elementor\Controls_Manager;
use \Elementor\Utils;

defined( 'ABSPATH' ) || die();

class Tx_Headers extends Element_El_Widget {

    /**
	 * Slider Style Dependency
	 *
	 * @return void
	 */
	public function get_style_depends() {
		return [ 'header-4' ];
	}

    /**
     * Get widget name.
     *
     * Retrieve Choicy Core widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'tx_headers';
    }

    /**
     * Get widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title() {
        return __( 'TX Headers', 'choicy-core' );
    }

    public function get_custom_help_url() {
        return 'http://elementor.themexriver.com/widgets/gradient-heading/';
    }

    /**
     * Get widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'elh-widget-icon eicon-t-letter';
    }

    public function get_keywords() {
        return ['btn', 'header', 'choicy', 'choicy header'];
    }

    // get menu by slug
    public function get_menu() {
        $menus = wp_get_nav_menus();
        $menu_list = [];
        if ( $menus ) {
            foreach ( $menus as $menu ) {
                $menu_list[$menu->slug] = $menu->name;
            }
        }
        return $menu_list;
    }

    protected function register_content_controls() {

        //Settings
        $this->start_controls_section(
            '_section_design_settings',
            [
                'label' => __( 'DESIGN STYLE', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'              => __( 'Design Style', 'choicy-core' ),
                'type'               => Controls_Manager::SELECT,
                'options'            => [
                    'style_1' => __( 'Header One', 'choicy-core' ),
                    'style_2' => __( 'Header two', 'choicy-core' ),
                    'style_3' => __( 'Header three', 'choicy-core' ),
                    'style_4' => __( 'Header Four', 'choicy-core' ),
                ],
                'default'            => 'style_1',
                'frontend_available' => true,
                'style_transfer'     => true,
            ]
        );

        $this->end_controls_section();

        // logo section
        $this->start_controls_section(
            '_section_logo',
            [
                'label' => __( 'Logo', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // logo
        $this->add_control(
            'logo',
            [
                'label'       => __( 'Logo', 'choicy-core' ),
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
            ]
        );

        // enable mobile logo
        $this->add_control(
            'enable_mobile_logo',
            [
                'label'        => __( 'Enable Mobile Logo', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'description'  => __( 'Enable mobile logo only for mobile device', 'choicy-core' ),
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // sideino logo
        $this->add_control(
            'mobile_logo',
            [
                'label'       => __( 'Mobile Logo', 'choicy-core' ),
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
                'condition'   => [
                    'enable_mobile_logo' => 'yes',
                ],
            ]
        );

        // enable sticky logo
        $this->add_control(
            'enable_sticky_logo',
            [
                'label'        => __( 'Enable Sticky Logo', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'description'  => __( 'Enable sticky logo only for sticky header', 'choicy-core' ),
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        // sticky logo
        $this->add_control(
            'sticky_logo',
            [
                'label'       => __( 'Sticky Logo', 'choicy-core' ),
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
                'condition'   => [
                    'enable_sticky_logo' => 'yes',
                ],
            ]
        );

        // enable custom link
        $this->add_control(
            'enable_custom_link',
            [
                'label'        => __( 'Enable Custom Link', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );

        // custom link
        $this->add_control(
            'custom_link',
            [
                'label'       => __( 'Custom Link', 'choicy-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'choicy-core' ),
                'show_label'  => false,
                'default'     => [
                    'url' => '#',
                ],
                'condition'   => [
                    'enable_custom_link' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
			'logo_width',
			[
				'label' => esc_html__( 'Max Width', 'gesto-plugin' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 5000,
					]
				],

				'selectors' => [
					'{{WRAPPER}} .tx-logo img' => 'max-width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .tx-logo img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        // end logo section
        $this->end_controls_section();

        $this->start_controls_section(
            '_section_menu',
            [
                'label' => __( 'Menu Options', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // select menu
        $this->add_control(
            'select_menu',
            [
                'label'       => __( 'Select Menu', 'choicy-core' ),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $this->get_menu(),
                'label_block' => true,
                'multiple'    => false,
            ]
        );

        // select mobile menu
        $this->add_control(
            'select_mobile_menu',
            [
                'label'       => __( 'Select Mobile Menu', 'choicy-core' ),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $this->get_menu(),
                'label_block' => true,
                'multiple'    => false,
            ]
        );

        $this->end_controls_section();

        // CONTACT NUMBER
        $this->start_controls_section(
            '_section_contact_number',
            [
                'label'     => __( 'Contact Number', 'choicy-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => ['style_3', 'style_4' ],
                ],
            ]
        );

        // enable icon
        $this->add_control(
            'enable_icon',
            [
                'label'        => __( 'Enable Icon', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // contact info icon
        $this->add_control(
            'contact_info_icon',
            [
                'label'       => __( 'Contact Info Icon', 'choicy-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fal fa-phone',
                    'library' => 'solid',
                ],
                'label_block' => true,
                'condition'   => [
                    'enable_icon' => 'yes',
                ],
            ]
        );

        // contact info label
        $this->add_control(
            'contact_info_label',
            [
                'label'       => __( 'Contact Info Label', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Call Us Now', 'choicy-core' ),
                'label_block' => true,
            ]
        );

        // contact info number
        $this->add_control(
            'contact_info_number',
            [
                'label'       => __( 'Contact Info Number', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( '+193-940-9845', 'choicy-core' ),
                'label_block' => true,
            ]
        );

        // END CONTACT NUMBER
        $this->end_controls_section();

        // BUTTON SECTION
        $this->start_controls_section(
            '_section_button',
            [
                'label'     => __( 'Button', 'choicy-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style'  => [
                        'style_2',
                        'style_3',
                        'style_4',
                    ],
                    'enable_button' => 'yes',
                ],
            ]
        );

        // button text
        $this->add_control(
            'button_text',
            [
                'label'       => __( 'Button Text', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Get Started', 'choicy-core' ),
                'label_block' => true,
            ]
        );

        // button link
        $this->add_control(
            'button_link',
            [
                'label'       => __( 'Button Link', 'choicy-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'choicy-core' ),
                'show_label'  => false,
                'default'     => [
                    'url' => '#',
                ],
            ]
        );

        // button icon
        $this->add_control(
            'button_icon',
            [
                'label'       => __( 'Button Icon', 'choicy-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fal fa-long-arrow-right',
                    'library' => 'solid',
                ],
                'label_block' => true,
            ]
        );

        // END BUTTON SECTION
        $this->end_controls_section();

        // side info section
        $this->start_controls_section(
            '_section_side_info',
            [
                'label' => __( 'Side Info', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // search_heading
        $this->add_control(
            'search_heading',
            [
                'label'       => __( 'Search Heading', 'choicy-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Search', 'choicy-core' ),
                'label_block' => true,
                'condition'   => [
                    'enable_search' => 'yes',
                ],
            ]
        );

        // gallery
        $this->add_control(
            'gallery_items',
            [
                'label'       => __( 'Gallery', 'choicy-core' ),
                'type'        => Controls_Manager::GALLERY,
                'label_block' => true,
                'condition'   => [
                    'enable_gallery' => 'yes',
                ],
            ]
        );

        // reapeter
        $repeater = new \Elementor\Repeater();

        // social_icon
        $repeater->add_control(
            'social_icon',
            [
                'label'       => __( 'Social Icon', 'choicy-core' ),
                'type'        => Controls_Manager::ICONS,
                'default'     => [
                    'value'   => 'fab fa-facebook-f',
                    'library' => 'solid',
                ],
                'label_block' => true,
            ]
        );

        // social_link
        $repeater->add_control(
            'social_link',
            [
                'label'       => __( 'Social Link', 'choicy-core' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'choicy-core' ),
                'show_label'  => false,
                'default'     => [
                    'url' => '#',
                ],
            ]
        );

        // social_links
        $this->add_control(
            'social_links',
            [
                'label'       => __( 'Social Links', 'choicy-core' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );

        // END side info section
        $this->end_controls_section();

        // settings section
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => __( 'SETTINGS', 'choicy-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        // has_inner_page
        $this->add_control(
            'has_inner_page',
            [
                'label'        => __( 'Has Inner Page?', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'description'  => __( 'Enable inner page only for style 1', 'choicy-core' ),
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'no',
                'condition'    => [
                    'design_style' => [
                        'style_1',
                    ],
                ],
            ]
        );

        // enable sticky header
        $this->add_control(
            'enable_sticky_header',
            [
                'label'        => __( 'ENABLE STICKY HEADER', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // ENABLE CART ICON
        $this->add_control(
            'enable_cart_icon',
            [
                'label'        => __( 'ENABLE CART ICON?', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => [
                        'style_1',
                        'style_4',
                    ],
                ],
            ]
        );

        // ENABLE CONTACT INFO
        $this->add_control(
            'enable_contact_info',
            [
                'label'        => __( 'ENABLE CONTACT INFO?', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => [
                        'style_3',
                    ],
                ],
            ]
        );

        // enable button
        $this->add_control(
            'enable_button',
            [
                'label'        => __( 'Enable Button', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'description'  => __( 'Enable button only for style 1', 'choicy-core' ),
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => [
                        'style_2',
                        'style_3',
                        'style_4',
                    ],
                ],
            ]
        );

        // enable search
        $this->add_control(
            'enable_search',
            [
                'label'        => __( 'Enable Search', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'description'  => __( 'Enable search only for style 1', 'choicy-core' ),
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
                'condition'    => [
                    'design_style' => [
                        'style_1',
                        'style_2',
                        'style_4',
                    ],
                ],
            ]
        );

        // enable gallery
        $this->add_control(
            'enable_gallery',
            [
                'label'        => __( 'Enable Gallery', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'description'  => __( 'Enable gallery only for style 1', 'choicy-core' ),
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // enable social links
        $this->add_control(
            'enable_social_links',
            [
                'label'        => __( 'Enable Social Links', 'choicy-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'description'  => __( 'Enable social links only for style 1', 'choicy-core' ),
                'label_on'     => __( 'Yes', 'choicy-core' ),
                'label_off'    => __( 'No', 'choicy-core' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );

        // end settings section
        $this->end_controls_section();

    }

    protected function register_style_controls() {

        $dir = dirname( __FILE__ );
        $style_files = glob( $dir . '/styles/*.php' );

        if ( $style_files ) {
            foreach ( $style_files as $style_file ) {
                include $style_file;
            }
        }

    }

    protected function render() {

        $settings = $this->get_settings_for_display();
        $dir = dirname( __FILE__ );

        $style = !empty( $settings['design_style'] ) ? $settings['design_style'] : 'style_1';

        switch ( $style ) {
        case 'style_3':
            include $dir . '/views/view-3.php';
            break;
        case 'style_2':
            include $dir . '/views/view-2.php';
            break;

        case 'style_4':
            include $dir . '/views/view-4.php';
            break;

        default:
            include $dir . '/views/view-1.php';
        }
    }
}
